package com.rocogz.syy.settlement.entity.issuingbody.collection;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;

import java.time.LocalDate;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 发放主体收款记录处理信息记录表
 * </p>
 *
 * @author ranxiangfu
 * @since 2021-07-30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SettleIssuingBodyCollectionRecordProcessInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 收款记录编码
     */
    private String collectionRecordCode;

    /**
     * 处理批次号
     */
    private String processBatchCode;

    /**
     * 本次去结算的总金额
     */
    private BigDecimal totalAmount;

    /**
     * 本次去结算的结算金额
     */
    private BigDecimal settledAmount;

    /**
     * 本次去结算的结算订单数量
     */
    private Integer settledOrderCount;

    /**
     * 本次去结算的盈余金额
     */
    private BigDecimal surplusAmount;

    /**
     * 是否处理完毕
     */
    private Boolean processFinished;

    /**
     * 处理失败原因
     */
    private String failReason;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 收款日期
     */
    @TableField(exist = false)
    private LocalDate collectionDate;
}
