package com.rocogz.syy.settlement.dto;

import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDate;
import java.util.List;

/**
 * @author djt
 * @date 2021/4/11
 */
@Data
@Accessors(chain = true)
public class AccountAdjustRecordSearchReq {

    /**
     * 调整记录编号
     */
    private String tradeNo;

    /**
     *账户编号
     */
    private String acctNo;

    /**
     * 账户类型
     * @see com.rocogz.syy.settlement.constant.SettlementConstant.DictAccountType
     */
    private String acctType;

    /**
     * 团队编号
     */
    private String teamCode;

    /**
     * 用户名称
     */
    private String  personName;

    /**
     * 用户名称
     */
    private String  personMobile;

    /**
     * 调整类型
     * @see com.rocogz.syy.settlement.constant.SettlementConstant.AccountAdjustType
     */
    private String  adjustType;

    /**
     * 调整类型列表
     */
    private List<String> adjustTypeList;

    /**
     * 账户状态
     * @see  com.rocogz.syy.settlement.constant.SettlementConstant.DictSwitchStatus
     */
    private String  status;

    /**
     * 来源账户编号
     */
    private String fromAcctNo;

    /**
     * 来源账户类型
     */
    private String fromAcctType;


    /**
     * 来源账户编号
     */
    private String toAcctNo;

    /**
     * 来源账户类型
     */
    private String toAcctType;


    /**
     * 上级账户编号（查询向下级划拨的流水的时候使用）
     */
    private String superiorAcctNo;

    /**
     * 下级发放主体账户编号（查询向下级发放主体账户划拨额度记录时使用）
     */
    private String lowerAcctNo;

    /**
     * 下级账户类型
     */
    private String lowerAcctType;


    /**
     * 开始日期
     */
    private LocalDate createDateStart;

    /**
     * 结束日期
     */
    private LocalDate createDateEnd;


    /**
     * 当前页
     */
    private int  page;

    /**
     * 页大小
     */
    private int limit;

    /**
     *  关键字
     */
    private String keyword;

    /**
     * 发放主体账号编号
     */
    private List<String> issuingBodyCodes;

    /**
     * 发放主体团队编号
     */
    private List<String> teamCodes;


}
