package com.rocogz.syy.settlement.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * @author 尹世豪
 * @Description: 操作发放主体账户状态dto
 * @Package com.rocogz.syy.dto.account
 * @date 2021/4/8 14:57
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
public class OperationAccountStatusDTO {
    /**
     * 账户编号
     */
    @NotBlank(message = "账户编号不能为空")
    private String acctNo;

    /**
     * 账户状态
     */
    @NotBlank(message = "账户状态不能为空")
    private String status;

    /**
     * 更新人
     */
    @NotNull(message = "更新人不能为空")
    private String updateUser;

    /**
     * 更新时间
     */
    @NotNull(message = "更新时间不能为空")
    private LocalDateTime updateTime;

}
