package com.rocogz.syy.settlement.entity.account;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.settlement.constant.SettlementConstant;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 账户关联信息表
 * </p>
 *
 * @author yinshihao
 * @since 2021-04-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("settle_account_info")
public class SettleAccountInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 账户编号(settle_account的acct_no)
     */
    private String acctNo;

    /**
     * 发放主体编号（发放主体账户才有）
     */
    private String issuingBodyCode;

    /**
     * 团队编号（团队账户才有）
     */
    private String teamCode;

    /**
     * 用户名(basic_system_admin_user的username)个人账户才有
     */
    private String personCode;

    /**
     * 用户名(basic_system_admin_user的name) 个人账户才有
     */
    private String personName;

    /**
     * 用户名(basic_system_admin_user的mobile) 个人账户才有
     */
    private String personMobile;

    /**
     * 额度扣减时点,即备付金扣减时机 (发放主体账户才有)
     */
    private String deductionTimeAppoint;

    /**
     * 额度扣减模式（个人账户才有）
     * @see SettlementConstant.DictDeductPattern
     */
    private String deductionPatten;

    /**
     * 团队账户数（发放主体账户才有）
     */
    private Integer teamAcctCount;

    /**
     * 个人账户数（发放主体账户才有）
     */
    private Integer personAcctCount;

    /**
     * 累计划拨团员数量（团队账户才有）
     */
    private Integer totalAllocatedCount;

    /**
     * 团员账户数（团队账户才有）
     */
    private Integer teamUserAcctCount;

    /**
     * 个人账户是否关联团队 0 否 1 是
     */
    private Integer personRefTeam;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    // ====以下为非PO属性

    //发放主体名称
    @TableField(exist = false)
    private String  issuingBodyName;

    /**
     * 团队名字
     */
    @TableField(exist = false)
    private String teamName;

    /**
     * 上级发放主体编号
     */
    @TableField(exist = false)
    private String pIssuingBodyCode;

    /**
     * 上级发放主体名称
     */
    @TableField(exist = false)
    private String pIssuingBodyName;

    //发放主体简称
    @TableField(exist = false)
    private String  issuingBodyAbbreviation;


}
