package com.rocogz.syy.settlement.entity.electronicaccount;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 电子账户流水表
 * </p>
 *
 * @author yifenrui
 * @since 2021-04-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("settle_electronic_account_flow")
public class SettleElectronicAccountFlow extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 电子账户编码
     */
    private String acctCode;

    /**
     * 关联的合作客户、代理商的编码
     */
    private String linkCode;

    /**
     * 流水编号
     */
    private String flowCode;

    /**
     * 业务编号
     */
    private String bizCode;

    /**
     * 额度模式(VIRTUAL_MODE:虚拟额度;RESERVE_PAYMENT:备付金)
     */
    private String quotaMode;

    /**
     * 流水类型(PAY:支付扣款(接口);REFUND:支付退款(接口);RECHARGE:手工充值(后台);DEDUCTION:手工减少额度(后台))
     */
    private String transactionType;

    /**
     * 交易金额
     */
    private BigDecimal transactionAmount;

    /**
     * 当前额度模式-账户余额-交易前
     */
    private BigDecimal acctBalanceCurrModeBefore;

    /**
     * 当前额度模式-账户余额-交易后
     */
    private BigDecimal acctBalanceCurrModeAfter;

    /**
     * 账户总余额-交易前
     */
    private BigDecimal acctBalanceBefore;

    /**
     * 账户总余额-交易后
     */
    private BigDecimal acctBalanceAfter;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;


}
