package com.rocogz.syy.settlement.entity.invoicematter;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Description: 服务商开票事项操作记录实体类
 * @date：2021/9/8
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("settle_invoice_matter_operation_record")
public class SettleInvoiceMatterOperationRecord extends IdEntity {

    private static final long serialVersionUID = 522713453978887093L;

    /**
    * 开票事项编码
    */
    private String invoiceMatterCode;
    
    /**
    * 操作项
    */
    private String operationItem;
    
    /**
    * 操作前状态
    */
    private String beforeOperationStatus;
    
    /**
    * 操作后状态
    */
    private String afterOperationStatus;
    
    /**
    * 操作人
    */
    private String operator;
    
    /**
    * 操作时间
    */
    private LocalDateTime operationTime;
}