package com.rocogz.syy.settlement.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.settlement.constant.SettlementConstant;
import com.rocogz.syy.settlement.entity.account.SettleAccountAdjustRecord;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 【搜索个人账户额度划拨记录结果】resultDto  4.9.4【我的账户】详情-主体账号专用
 * @author zhangmin
 * @date 2021/4/8
 */
@Setter @Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class AdminSearchPersonalAdjustRecordResultDto extends SettleAccountAdjustRecord {

    //关联的团队/发放主体信息
    private SuperiorAccountDto refAccountDto;

    /**
     * 调整类型Label
     */
    private String allocateTypeLabel;

    /**
     * 额度来源账户类型 Label
     */
    private String originAcctTypeLabel;

    /**
     * 额度来源账户类型
     * @return
     */
    public String getOriginAcctType() {

        String originAcctType = "";

        switch (getAllocateType()) {

            case SettlementConstant.AccountAdjustType.ALLOCATE_IN:
            case SettlementConstant.AccountAdjustType.AUTO_ALLOCATE_IN:
                originAcctType = getFromAcctType();
                break;


            case SettlementConstant.AccountAdjustType.ALLOCATE_BACK_OUT:
            case SettlementConstant.AccountAdjustType.AUTO_ALLOCATE_BACK_OUT:
                originAcctType = getToAcctType();
                break;
        }

        return originAcctType;
    }

}
