package com.rocogz.syy.settlement.entity.electronicaccount;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDate;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author yifenrui
 * @since 2021-04-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("settle_electronic_account_quota_provision")
public class SettleElectronicAccountQuotaProvision extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 业务单号
     */
    private String code;

    /**
     * 电子账户code
     */
    private String acctCode;

    /**
     * 额度
     */
    private BigDecimal quota;

    /**
     * 付款日期
     */
    private LocalDate payDate;

    /**
     * 收款日期
     */
    private LocalDate collectDate;

    /**
     * 付款凭证
     */
    private String payVoucherImg;

    /**
     * 收款凭证
     */
    private String collectVoucherImg;

    /**
     * 备注
     */
    private String remark;

    /**
     * 操作时间
     */
    private LocalDateTime createTime;

    /**
     * 操作人
     */
    private String createUser;


    /**
     * 充值类型
     *
     * 字典类型 ：ELECTRONIC_ACCT_PROVISION_TYPE
     *
     * 字典值：COLLECT:收款充值，CREDIT:授信充值
     */
    private String type;

    /**
     * 字典值类型名称
     */
    @TableField(exist = false)
    private String typeName;


    /**
     * 已还金额
     */
    private BigDecimal repaidQuota;

    /**
     * 未还金额
     */
    private BigDecimal notRepaidQuota;

    /**
     * 已使用金额
     */
    private BigDecimal usedQuota;

    /**
     * 还款业务单号
     */
    private String bizCode;

    /**
     * 还款时间
     */
    private LocalDateTime repaidTime;


    /**
     * 还款情况
     *
     * 字典类型 ：ELECTRONIC_ACCT_PROVISION_STATUS
     *
     * 字典值：REPAID：已还，NOT_REPAID:未还,HALF_REPAID：部分还款
     */
    private String status;

    @TableField(exist = false)
    private String statusName;

    @TableField(exist = false)
    private String linkCode;


    @TableField(exist = false)
    private String linkName;


    @TableField(exist = false)
    private String linkType;

    /**
     * 本次收款归还借款金额(元)
     */
    @TableField(exist = false)
    private BigDecimal collectQuota;

    /**
     * 本次使用时变动了多少金额
     */
    @TableField(exist = false)
    private BigDecimal currentChangedQuota;



    @TableField(exist = false)
    private String customerType;

    @TableField(exist = false)
    private String customerAgent;


    @TableField(exist = false)
    private String customerAgentCode;
}
