package com.rocogz.syy.settlement.dto;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import java.util.List;

/**
 * @author djt
 * @date 2021/4/11
 */
@Data
@Accessors(chain = true)
public class AccountSearchReq {

    /**
     * 账户编号
     */
    private String acctNo;

    /**
     * 账户类型
     */
    @NotBlank
    private String acctType;

    /**
     * 团队编号
     */
    private String teamCode;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 归属发放主体编号
     */
    private String belongIssuingBodyCode;

    /**
     * 归属团队编号
     */
    private String belongTeamCode;

    /**
     * 是否绑定团队
     */
    private Integer personRefTeam;

    /**
     * 账户状态
     */
    private String status;

    /**
     * 额度扣减模式
     */
    private String  deductionPatten;

    /**
     * 用户名称
     */
    private String  personName;

    /**
     * 用户手机号
     */
    private String personMobile;

    /**
     * 排序字段
     */
    private String orderByField;

    /**
     *  排序规则
     */
    @Pattern(regexp = "^(asc|desc)$")
    private String  sort;

    /**
     * 发放主体编号列表
     */
    private List<String> issuingBodyCodes;

    /**
     * 关键字
     */
    private String keyword;

    /**
     * 团队编号
     */
    private List<String> teamCodes;


    /**
     * 当前页
     */
    private int page;

    /***
     * 页大小
     */
    private int limit;

}
