package com.rocogz.syy.settlement.entity.issuingbody.collection;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 发放主体收款记录表
 * </p>
 *
 * @author ranxiangfu
 * @since 2021-07-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SettleIssuingBodyCollectionRecord extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 收款单号
     */
    private String code;

    /**
     * 服务商(代理商)编号
     */
    private String agentCode;

    /**
     * 结算主体编号
     */
    private String settleSubjectCode;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 收款金额
     */
    private BigDecimal collectionAmount;


    /**
     * 收款日期
     */
    private LocalDate collectionDate;

    /**
     * 收款凭证
     */
    private String collectionVoucherImg;

    /**
     * 收款备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 收款类型
     */
    private String collectionType;

    /**
     * 发票张数
     */
    private Integer invoiceCnt;

    /**
     * 业务归属年份和月份
     */
    private String businessYearAndMonth;

    /**
     * 所属结算单位编号
     */
    private String belongSettlementUnit;

    /**
     * 代理商简称
     */
    @TableField(exist = false)
    private String agentAbbreviation;

    /**
     * 结算主体简称
     */
    @TableField(exist = false)
    private String settleSubjectAbbreviation;

    /**
     * 发放主体简称
     */
    @TableField(exist = false)
    private String issuingBodyAbbreviation;

    /**
     * 收款类型 - 名称
     */
    @TableField(exist = false)
    private String collectionTypeName;

    /**
     * 开票事项编号列表
     */
    @TableField(exist = false)
    private List<String> invoiceMatterCodeList;

    /**
     * 收款明细列表
     */
    @TableField(exist = false)
    private List<SettleIssuingBodyCollectionRecordItem> itemList;

    /**
     * 结算金额（汇总）
     */
    @TableField(exist = false)
    private BigDecimal settledAmountTotal;

    /**
     * 盈余金额（汇总）
     */
    @TableField(exist = false)
    private BigDecimal surplusAmountTotal;

    /**
     * 结算订单数量（汇总）
     */
    @TableField(exist = false)
    private Integer settledOrderCountTotal;

}
