package com.rocogz.syy.settlement.dto;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * @author djt
 * @date 2021/4/12
 */
@Data
@Accessors(chain = true)
public class AccountSaveReq {

    /**
     * 账户类型
     */
    @NotBlank(message = "账户类型不能为空")
    private String acctType;

    /**
     * 团队编号
     */
    private String teamCode;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 用户名
     */
    private String username;

    /**
     * 用户真实姓名
     */
    private String personName;

    /**
     * 用户手机号
     */
    private String personMobile;

    /**
     * 归属发放主体编号
     */
    private String belongIssuingBodyCode;

    @NotBlank(message = "创建人username不能为空")
    private String createUser;

    /**
     * 额度扣减模式
     */
    private String deductionPatten;

}
