package com.rocogz.syy.settlement.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * @author djt
 * @date 2021/4/8
 */
@Data
public class AddAccountResDTO {

    /**
     * 账户类型
     *
     */
    @NotBlank(message = "账户类型不能为空")
    private String acctType;

    /**
     * 发放主体编号
     */
    @NotBlank(message = "发放主体编号不能为空")
    private String issuingBodyCode;

    /**
     * 上级发放主体编号
     */
    private String pIssuingBodyCode;

    /**
     * 团队编号（团队账户才有）
     */
    private String teamCode;

    /**
     * 用户名(basic_system_admin_user的username)个人账户才有
     */
    private String personCode;

    /**
     * 用户名(basic_system_admin_user的name) 个人账户才有
     */
    private String personName;

    /**
     * 用户名(basic_system_admin_user的mobile) 个人账户才有
     */
    private String personMobile;

    /**
     * 额度扣减时点(发放主体账户才有)
     */
    private String deductionTimeAppoint;

    /**
     * 额度扣减模式（个人账户才有）
     */
    private String deductionPatten;

    /**
     * 创建人
     */
    @NotNull(message = "创建人不能为空")
    private String createUser;

    /**
     * 创建时间
     */
    @NotNull(message = "创建时间不能为空")
    private LocalDateTime createTime;
}
