package com.rocogz.syy.settlement.dto.invoicematter;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description: 批量提交开票事项Dto
 * @date：2021/10/13
 * @author：huangdeyi
 */
@Data
public class BatchCommitInvoiceMatterReqDto {

    /**
     * 编码
     */
    private String code;

    /**
     * 前一个状态
     */
    private String preStatus;

    /**
     * 当前状态
     */
    private String status;

    /**
     * 发票代码
     */
    private String invoiceCode;

    /**
     * 发票号码
     */
    private String invoiceNo;

    /**
     * 发票金额
     */
    private BigDecimal invoiceAmount;

    /**
     * 发票税额
     */
    private BigDecimal invoiceTaxAmount;

    /**
     * 发票含税金额
     */
    private BigDecimal invoiceIncludeTaxAmount;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
