package com.rocogz.syy.settlement.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.settlement.dto.*;
import com.rocogz.syy.settlement.dto.datapermission.DPSettleSubjectTreeDto;
import com.rocogz.syy.settlement.dto.electronic.account.*;
import com.rocogz.syy.settlement.dto.invoicematter.*;
import com.rocogz.syy.settlement.dto.invoicematter.invoice.InvoiceMatterInvoiceDetailRespDto;
import com.rocogz.syy.settlement.dto.invoicematter.invoice.InvoiceMatterInvoicePageListRespDto;
import com.rocogz.syy.settlement.dto.invoicematter.invoice.InvoiceMatterInvoiceToVoidReqDto;
import com.rocogz.syy.settlement.dto.invoicematter.matter.InvoiceMatterCancelReq;
import com.rocogz.syy.settlement.dto.invoicematter.matter.InvoiceMatterConfirmKPReq;
import com.rocogz.syy.settlement.dto.issuingbody.collection.IssuingCustomerAndProductParamDto;
import com.rocogz.syy.settlement.dto.issuingbody.collection.SettleIssuingBodyCollectionRecordPageQuery;
import com.rocogz.syy.settlement.dto.issuingbody.collection.SettledResultSaveDto;
import com.rocogz.syy.settlement.entity.SettleSubject;
import com.rocogz.syy.settlement.entity.account.SettleAccount;
import com.rocogz.syy.settlement.entity.account.SettleAccountAdjustRecord;
import com.rocogz.syy.settlement.entity.account.SettleAccountInfo;
import com.rocogz.syy.settlement.entity.electronicaccount.*;
import com.rocogz.syy.settlement.entity.invoicematter.SettleInvoiceMatter;
import com.rocogz.syy.settlement.entity.issuingbody.collection.SettleIssuingBodyCollectionRecord;
import com.rocogz.syy.settlement.entity.issuingbody.collection.SettleIssuingBodyCollectionRecordItem;
import com.rocogz.syy.settlement.entity.issuingbody.collection.SettleIssuingBodyCollectionRecordProcessInfo;
import com.rocogz.syy.settlement.entity.issuingbody.collection.SettleIssuingBodyCollectionRecordSettleDetail;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * <dl>
 * <dd>Description: 结算中心对外feign接口 service</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020-04-30 上午 7:18</dd>
 * <dd>@author：yifenrui</dd>
 * </dl>
 */
public interface ISettlementClientService {

    //  =========  start of 结算主体 模块   ===========

    /**
     * 结算主体管理-结算主体列表
     *
     * @param code                  the code
     * @param name                  the name
     * @param settleSubjectList     the settle subject list
     * @param type                  the type
     * @param abbreviation          the abbreviation
     * @param agentCodeList         the agent code list
     * @param removeSubjectCodeList the remove subject code list
     * @param status                the status
     * @param limit                 the limit
     * @param page                  the page
     * @return page table
     */
    @GetMapping("/api/settle/subject")
    PageTable<SettleSubject> searchSettleSubject(@RequestParam(name = "code",required = false) String code,
                                          @RequestParam(name = "name",required = false) String name,
                                          @RequestParam(name = "settleSubjectList",required = false) List<String> settleSubjectList,
                                          @RequestParam(name = "type",required = false) String type,
                                          @RequestParam(name = "abbreviation",required = false) String abbreviation,
                                          @RequestParam(name = "agentCodeList",required = false) List<String> agentCodeList,
                                          @RequestParam(name = "removeSubjectCodeList",required = false) List<String> removeSubjectCodeList,
                                          @RequestParam(name = "status",required = false) String status,
                                          @RequestParam(name = "limit",defaultValue = "20") Integer limit,
                                          @RequestParam(name = "page",defaultValue = "1") Integer page);


    /**
     * 结算主体管理-更新结算主体的状态
     *
     * @param settleSubject the settle subject
     * @return response
     */
    @PostMapping("/api/settle/subject/switchSettleSubjectStatus")
    Response switchSettleSubjectStatus(@RequestBody SettleSubject settleSubject);

    /**
     * 结算主体管理-根据id删除
     *
     * @param id the id
     * @return response
     */
    @PostMapping("/api/settle/subject/deleteSettleSubject")
    Response deleteSettleSubject(@RequestParam(name = "id") Integer id);

    /**
     * 新增和更新结算主体
     *
     * @param settleSubject the settle subject
     * @return response
     */
    @PostMapping("/api/settle/subject/createOrUpdateSettleSubject")
    Response createOrUpdateSettleSubject(@RequestBody SettleSubject settleSubject);


    /**
     * 结算主体管理-根据id查询结算主体
     *
     * @param id the id
     * @return settle subject by id
     */
    @GetMapping("/api/settle/subject/detail/{id}")
    Response<SettleSubject> getSettleSubjectById(@PathVariable("id") Integer id);

    /**
     * 结算主体管理-根据code查询结算主体
     *
     * @param code the code
     * @return settle subject by code
     */
    @GetMapping("/api/settle/subject/{code}")
    Response<SettleSubject> getSettleSubjectByCode(@PathVariable("code") String code);


    /**
     * 版块管理-新增获取主体code
     *
     * @return settle subject code
     */
    @GetMapping("/api/settle/subject/getSettleSubjectCode")
     Response<String> getSettleSubjectCode();


    /**
     * 结算主体管理-查找主体类型下的name是否存在
     *
     * @param code the code
     * @param type the type
     * @param name the name
     * @return check name
     */
    @PostMapping("/api/settle/subject/getCheckName")
    List<SettleSubject> getCheckName(@RequestParam(name = "code") String code,@RequestParam(name = "type") String type,@RequestParam(name = "name") String name);

    /**
     * yinshihao 数据权限管理时，需要获取无分页结算主体信息,只有code和name
     *
     * @return the subject list
     */
    @GetMapping("/api/settle/subject/settleSubjectList")
    Response<List<SettleSubject>> settleSubjectList();

    /**
     * 获取结算主体列表
     *
     * @param code              the code
     * @param settleSubjectList the settle subject list
     * @param abbreviation      the abbreviation
     * @param agentCodeList     the agent code list
     * @param status            the status
     * @return response
     */
    @GetMapping("/api/settle/subject/findSettleSubjectList")
    Response<List<SettleSubject>> findSettleSubjectList(@RequestParam(name = "code", required = false) String code,
                                                        @RequestParam(name = "settleSubjectList", required = false) List<String> settleSubjectList,
                                                        @RequestParam(name = "abbreviation", required = false) String abbreviation,
                                                        @RequestParam(name = "agentCodeList",required = false) List<String> agentCodeList,
                                                        @RequestParam(name = "status", required = false) String status);

    /**
     * 根据结算主体编号列表获取结算主体列表
     *
     * @param settleSubjectList the settle subject list
     * @return response
     */
    @GetMapping("/api/settle/subject/findSettleSubjectListByCodeList")
    Response<List<SettleSubject>> findSettleSubjectListByCodeList(@RequestParam(name = "settleSubjectList") List<String> settleSubjectList,
                                                                  @RequestParam(name = "status", required = false) String status);

    /**
     * 根据代理商编码获取属于该代理商的结算主体
     *
     * @param agentCode the agent code
     * @return response
     */
    @GetMapping("/api/settle/subject/findIssuingBodyListByAgentCode")
    Response<List<SettleSubject>> findSettleSubjectListByAgentCode(@RequestParam(name = "agentCode") String agentCode);
    // =========  end of  结算主体 模块   ===========

    //  =========  start of 账户 模块   ===========

    /**
     * 发放主体分页查询
     *
     * @param accountResDto the account res dto
     * @return page table
     */
    @PostMapping("/api/settle/account/queryPage")
    PageTable<SettleAccount> accountPageTable(@RequestBody AccountResDTO accountResDto);

    /**
     * 发放主体列表查询
     *
     * @param accountResDto the account res dto
     * @return response
     */
    @PostMapping("/api/settle/account/findAccountList")
    Response<List<SettleAccount>> findAccountList(@RequestBody AccountResDTO accountResDto);

    /**
     * 保存账户
     *
     * @param addAccountResDTO the add account res dto
     * @return response
     */
    @PostMapping("/api/settle/account/saveSettleAccount")
    Response<SettleAccount> saveSettleAccount(@RequestBody AddAccountResDTO addAccountResDTO);

    /**
     * 设置发放主体账户额度扣减时点
     *
     * @param acctNos              the acct nos
     * @param deductionTimeAppoint the deduction time appoint
     * @param updateUser           the update user
     * @return response
     */
    @GetMapping("/api/settle/account/editDeductionTimeAppoint")
    Response editDeductionTimeAppoint(@RequestParam("acctNos") List<String> acctNos,
                                      @RequestParam("deductionTimeAppoint") String deductionTimeAppoint,
                                      @RequestParam("updateUser") String updateUser);

    /**
     * 操作发放主体账户状态
     *
     * @param accountStatusDTO the account status dto
     * @return response
     */
    @PostMapping("/api/settle/account/operateStatus")
    Response operateStatus(@RequestBody OperationAccountStatusDTO accountStatusDTO);

    /**
     * 调整发放主体账户额度
     *
     * @param operationAccountAmountDTO the operation account amount dto
     * @return response
     */
    @PostMapping("/api/settle/account/operationAccountAmount")
    Response operationAccountAmount(@RequestBody OperationAccountAmountDTO operationAccountAmountDTO);

    /**
     * 根据账户编号查询账户信息,包括账户关联信息
     *
     * @param acctNo the acct no
     * @return all info by acc no
     */
    @GetMapping("/api/settle/account/getAllInfoByAccNo")
    Response<SettleAccount> getAllInfoByAccNo(@RequestParam("acctNo") String acctNo);

    /**
     * 发放主体账户额度划拨记录分页查询
     *
     * @param accountResDto the account res dto
     * @return page table
     */
    @PostMapping("/api/settle/account/accountOperationLogPageTable")
    PageTable<SettleAccountAdjustRecord> accountOperationLogPageTable(@RequestBody AccountOperationLogResDTO accountResDto);

    /**
     * 根据账户编号列表查询账户信息
     *
     * @param acctNos the acct nos
     * @return response
     */
    @GetMapping("/api/settle/account/findByAccNos")
    Response<List<SettleAccount>> findByAccNos(@RequestParam("acctNos") List<String> acctNos);

    /**
     * 根据团队编码删除账户信息
     *
     * @param teamCode the team code
     * @return response
     */
    @RequestMapping("/api/settle/account/deleteByTeamCode")
    Response deleteByTeamCode(@RequestParam("teamCode") String teamCode);

    /**
     * 根据发放主体编号获取发放主体账户信息
     *
     * @param issuingBodyCode the issuing body code
     * @return all info by issuing body code
     */
    @GetMapping("/api/settle/account/getAllInfoByIssuingBodyCode")
    Response<SettleAccount> getAllInfoByIssuingBodyCode(@RequestParam("issuingBodyCode") String issuingBodyCode);

    /**
     * 根据发放主体编码修改上级编码
     *
     * @param updateAccountResDTO the update account res dto
     */
    @PostMapping("/api/settle/account/updateByIssuingBodyCodeAndPCode")
    void updateByIssuingBodyCodeAndPCode(@RequestBody @Validated UpdateAccountResDTO updateAccountResDTO);

    /**
     * 根据账户编号查询账户信息,包括账户关联信息 --不查 已划拨已使用额度和已划拨未使用额度
     *
     * @param acctNo
     * @return
     */
    @GetMapping("/api/settle/account/getAllByAcctNo")
    Response<SettleAccount> getAllByAcctNo(@RequestParam("acctNo") String acctNo);

    /**
     * 根据发放主体编号获取发放主体账户信息  --不查 已划拨已使用额度和已划拨未使用额度
     *
     * @param issuingBodyCode
     * @return
     */
    @GetMapping("/api/settle/account/getAllByIssuingBodyCode")
    Response<SettleAccount> getAllByIssuingBodyCode(@RequestParam("issuingBodyCode") String issuingBodyCode);


    /**
     * 根据用户获取对应的发放主体账户
     * @param username
     * @return
     */
    @GetMapping("/api/settle/account/getIssuingBodyAccountByUserName")
    Response<SettleAccount> getIssuingBodyAccountByUserName(@RequestParam("username") String username);
    // =========  end of  账户 模块   ===========




    //  =========  start of 个人账户 模块   ===========


    /**
     * 获取个人账户，以及关联的账户信息
     *
     * @param userName 登录的主体账号对应的用户名
     * @return the personal account profile
     */
    @GetMapping("/api/settle/personalAccount/info/getPersonalAccountProfile")
    Response<AccountProfileDto> getPersonalAccountProfile(@RequestParam("userName") String userName);

    /**
     * 获取账户编号获取个人账户，以及关联的账户信息
     *
     * @param acctNo 登录的主体账号对应的用户名
     * @return the personal account profile by acct no
     */
    @GetMapping("/api/settle/personalAccount/info/getPersonalAccountProfileByAcctNo")
    Response<AccountProfileDto> getPersonalAccountProfileByAcctNo(@RequestParam("acctNo") String acctNo);

    /**
     * 个人账户 额度划拨记录
     *
     * @param searchParamDto the search param dto
     * @return the page table
     */
    @GetMapping("/api/settle/personalAccount/info/searchAdjustRecord")
    PageTable<AdminSearchPersonalAdjustRecordResultDto> adminSearchAdjustRecord(@SpringQueryMap AdminSearchPersonalAdjustRecordDto searchParamDto);


    /**
     * 获得发放主体账户以及关联的信息
     *
     * @param userName 登录的主体账号对应的用户名
     * @return the issue body account profile
     */
    @GetMapping("/api/settle/personalAccount/manage/getIssueBodyAccountProfile")
    Response<SettleAccount> getIssueBodyAccountProfile(@RequestParam("userName") String userName);

    /**
     * 搜索个人账户列表
     *
     * @param searchParamDto the search param dto
     * @return the page table
     */
    @GetMapping("/api/settle/personalAccount/manage/searchAccount")
    PageTable<AdminSearchPersonalAccountResultDto> adminSearchPersonalAccount(@SpringQueryMap AdminSearchPersonalAccountDto searchParamDto);


    /**
     * 批量启用/停用 账户
     *
     * @param acctNoList 批量操作的账户列表
     * @param newStatus  要更新的新状态
     * @return the response
     */
    @GetMapping("/api/settle/personalAccount/manage/switchStatus")
    public Response<String> switchAccountStatus(@RequestParam("acctNoList") List<String> acctNoList, @RequestParam("newStatus") String newStatus);


    /**
     * 修改 个人账户扣减模式
     *
     * @param acctNo           个人账号
     * @param newDeductPattern 新的扣减模式
     * @return the response
     */
    @GetMapping("/api/settle/personalAccount/manage/switchDeductPattern")
    Response<String> switchDeductPattern(@RequestParam("acctNo") String acctNo, @RequestParam("newDeductPattern") String newDeductPattern);


    /**
     * 批量修改 个人账户扣减模式
     *
     * @param acctNoList       个人账号列表
     * @param newDeductPattern 新的扣减模式
     * @return the response
     */
    @GetMapping("/api/settle/personalAccount/manage/batchSwitchDeductPattern")
    Response<String> batchSwitchDeductPattern(@RequestParam("acctNoList") List<String> acctNoList, @RequestParam("newDeductPattern") String newDeductPattern);


    /**
     * 根据用户名列表查询账户
     *
     * @param usernameList the username list
     * @return account by username list
     */
    @PostMapping("/api/settle/account/getAccountByUsernameList")
    Response<List<SettleAccount>> getAccountByUsernameList(@RequestBody List<String> usernameList);

    /**
     * 根据用户名列表查询账户
     *
     * @param username the username
     * @return person amount by username
     */
    @GetMapping("/api/settle/account/getPersonAmountByUsername")
    Response<PersonAccountAmountResp> getPersonAmountByUsername(@RequestParam("username")  String username);



    // =========  end of  个人账户 模块   ===========


    /**
     * 账户交易
     *
     * @param req the req
     * @return response
     */
    @PostMapping("/api/settle/account/trade")
    Response<TradeResp> trade(@RequestBody @Validated AccountTradeReq req);


    /**
     * 分页查询账户
     *
     * @param req the req
     * @return page table
     */
    @PostMapping("/api/settle/account/base/page")
    PageTable<SettleAccount> listPageAccount(@SpringQueryMap AccountSearchReq req);

    /**
     * 分页查询账户
     *
     * @param req the req
     * @return response
     */
    @PostMapping("/api/settle/account/base/all")
    Response<List<SettleAccount>> listAllAccount(@SpringQueryMap AccountSearchReq req);

    /**
     * 保存账户
     *
     * @param req the req
     * @return response
     */
    @PostMapping("/api/settle/account/base/save")
    Response saveAccount(@RequestBody AccountSaveReq req);


    /**
     * 修改团队账户状态
     *
     * @param acctNo the acct no
     * @param status the status
     * @return response
     */
    @GetMapping("/api/settle/account/team/switchStatus")
    Response switchTeamAccountStatus(@RequestParam("acctNo")String acctNo,@RequestParam("status")String status);


    /**
     * 根据账户编号获取所有的账户信息
     *
     * @param acctNo the acct no
     * @return account all info by acct no
     */
    @GetMapping("/api/settle/account/base/getByAcctNo")
    Response<SettleAccount> getAccountAllInfoByAcctNo(@RequestParam("acctNo")String acctNo);


    /**
     * 根据teamCode获取teamAccount
     *
     * @param teamCode the team code
     * @return team account by team code
     */
    @GetMapping("/api/settle/account/team/getAccountByTeamCode")
    Response<SettleAccount> getTeamAccountByTeamCode(@RequestParam("teamCode")String teamCode);


    /**
     * 根据teamCode获取teamAccount
     *
     * @param req the req
     * @return acct by owner
     */
    @PostMapping("/api/settle/account/getAcctByOwner")
    Response<List<SettleAccount>> getAcctByOwner(@RequestBody AccountOwnerSearchReq req);

    /**
     * 个人账户绑定团队
     *
     * @param userNames the user names
     * @param teamCode  the team code
     * @return response
     */
    @GetMapping("/api/settle/account/team/boundTeam")
    Response boundTeam(@RequestParam("usernames") List<String> userNames,@RequestParam("teamCode")String teamCode);

    /**
     * 个人账户绑定团队
     *
     * @param usernames the usernames
     * @return response
     */
    @GetMapping("/api/settle/account/team/unboundTeam")
    Response unboundTeam(@RequestParam("usernames") List<String> usernames);

    /**
     * 更改发放主体
     *
     * @param username           the username
     * @param oldIssuingBodyCode the old issuing body code
     * @param newIssuingBodyCode the new issuing body code
     * @return response
     */
    @GetMapping("/api/settle/account/changeIssuingBody")
    Response changeIssuingBody(@RequestParam("username")String username, @RequestParam("oldIssuingBodyCode")String oldIssuingBodyCode,@RequestParam("newIssuingBodyCode")String newIssuingBodyCode);

    /**
     * 更改名称
     *
     * @param username the username
     * @param newName  the new name
     * @return response
     */
    @GetMapping("/api/settle/account/changeName")
    Response changeName(@RequestParam("username")String username, @RequestParam("newName")String newName);

    /**
     * get account by username
     *
     * @param username the username
     * @return account by username
     */
    @GetMapping("/api/settle/account/getByUsername")
    Response<SettleAccount> getAccountByUsername(@RequestParam("username")String username);


    /**
     * 账户调整记录查询
     *
     * @param req the req
     * @return page table
     */
    @PostMapping("/api/settle/account/adjust/page")
    PageTable<AccountAdjustRecordListResp> listPageAccountAdjustRecord(@SpringQueryMap AccountAdjustRecordSearchReq req);

    /**
     * 账户调整记录不分页查询
     *
     * @param req the req
     * @return response
     */
    @PostMapping("/api/settle/account/adjust/all")
    Response<List<AccountAdjustRecordListResp>> listAllAccountAdjustRecord(@SpringQueryMap AccountAdjustRecordSearchReq req);

    /**
     * 统计发放主体账户划拨数量和金额
     *
     * @param req the req
     * @return response
     */
    @PostMapping("/api/account/statistics/allocateAmountStat")
    Response<AccountAllocateStatisticsResp> allocateAmountStat(@RequestBody AccountAllocateStatisticsReq req);

    /**
     * 统计发放主体账户划拨数量
     *
     * @param req the req
     * @return response
     */
    @PostMapping("/api/account/statistics/allocateCountStat")
    Response<AccountAllocateCountResp> allocateCountStat(@RequestBody AccountAllocateStatisticsReq req);

    /**
     * 统计发放主体账户划拨数量
     *
     * @param req the req
     * @return response
     */
    @GetMapping("/api/account/statistics/childOrgStat")
    Response<AccountCommonStatisticsResp> childOrgStat(@SpringQueryMap AccountSearchReq req);


    /**
     * Gets by issuing body code.
     *
     * @param issuingBodyCode the issuing body code
     * @return the by issuing body code
     */
// =========  start of  SettleAccountInfoController 模块   ===========
    @GetMapping("/api/settle/accountInfo/getByIssuingBodyCode")
    Response<SettleAccountInfo> getByIssuingBodyCode(@RequestParam("issuingBodyCode") String issuingBodyCode);

    /**
     * 根据发放主体编号减去方法主体账户中团队数量
     *
     * @param issuingBodyCode the issuing body code
     * @return response
     */
    @GetMapping("/api/settle/accountInfo/deleteIssuingBodyAcctCount")
    Response deleteIssuingBodyAcctCount(@RequestParam("issuingBodyCode") String issuingBodyCode);
    // =========  end of  SettleAccountInfoController 模块   ===========

    // =========  start of  电子账户 模块 by ranxiangfu  ===========

    /**
     * 订单支付-电子账户余额扣减.
     *
     * @param dto the dto
     * @return the response
     */
    @PostMapping("/electronic/settleElectronicAccountInfo/deductionByOrder")
    Response<String> deductionElectronicAcctBalanceByOrder(@Validated @RequestBody OperateElectronicAcct dto);

    /**
     * 订单退款.
     *
     * @param dto the dto
     * @return the response
     */
    @PostMapping("/electronic/settleElectronicAccountInfo/refund")
    Response<String> electronicAcctRefund(@Validated @RequestBody SettleElectronicAcctOrderRefundParamDto dto);

    /**
     * 根据linkCode查询电子账户信息.
     *
     * @param linkCode the link code
     * @return the response
     */
    @GetMapping("/electronic/settleElectronicAccountInfo/getByLinkCode")
    Response<SettleElectronicAccountInfo> getElectronicAcctByLinkCode(@RequestParam("linkCode") String linkCode);

    /**
     * 对电子账户进行余额增加，额度模式是备付金时：默认的操作类型是借款授信
     *
     * @param operateElectronicAcct the operate electronic acct
     * @return response
     */
    @PostMapping("/electronic/settleElectronicAccountInfo/addElectronicAccountBalanceByLinkCode")
    Response<String> addElectronicAccountBalanceByLinkCode(@RequestBody OperateElectronicAcct operateElectronicAcct);

    /**
     * 更新电子账户余额到redis.
     *
     * @param acctCode the acct code
     * @return the response
     */
    @GetMapping("/electronic/settleElectronicAccountInfo/updateBalance2Redis")
    Response updateElectronicAcctBalance2Redis(@RequestParam(value = "acctCode", required = false) String acctCode);

    /**
     * 增加已发放额度
     *
     * @param linkCode the link code
     * @param amount   the amount
     * @return response
     */
    @GetMapping("/electronic/settleElectronicAccountSummaryInfo/addGrantQuota")
    Response electronicAcctSummaryInfoAddGrantQuota(@RequestParam("linkCode") String linkCode,
                                                    @RequestParam("amount") BigDecimal amount);

    /**
     * 增加已领取额度
     *
     * @param linkCode the link code
     * @param amount   the amount
     * @return response
     */
    @GetMapping("/electronic/settleElectronicAccountSummaryInfo/addReceiveQuota")
    Response electronicAcctSummaryInfoAddReceiveQuota(@RequestParam("linkCode") String linkCode,
                                                      @RequestParam("amount") BigDecimal amount);

    /**
     * 根据电子账户code查询统计信息
     *
     * @param acctCode the acct code
     * @return electronic acct summary info by acct code
     */
    @GetMapping("/electronic/settleElectronicAccountSummaryInfo/getByAcctCode")
    Response<SettleElectronicAccountSummaryInfo> getElectronicAcctSummaryInfoByAcctCode(
            @RequestParam("acctCode") String acctCode);

    /**
     * 根据电子账户linkCode查询统计信息
     *
     * @param linkCode the link code
     * @return electronic acct summary info by link code
     */
    @GetMapping("/electronic/settleElectronicAccountSummaryInfo/getByLinkCode")
    Response<SettleElectronicAccountSummaryInfo> getElectronicAcctSummaryInfoByLinkCode(
            @RequestParam("linkCode") String linkCode);

    /**
     * 虚拟额度调整记录-分页查询.
     *
     * @param queryDto the query dto
     * @return page table
     */
    @PostMapping("/electronic/settleElectronicAccountQuotaManual/pageQuery")
    PageTable<SettleElectronicAccountQuotaManual> settleElectronicAccountQuotaManualPageQuery(
            @RequestBody SettleElectronicAccountQuotaManualQueryDto queryDto);

    /**
     * 备付金充值记录-分页查询.
     *
     * @param queryDto the query dto
     * @return page table
     */
    @PostMapping("/electronic/settleElectronicAccountQuotaProvision/pageQuery")
    PageTable<SettleElectronicAccountQuotaProvision> settleElectronicAccountQuotaProvisionPageQuery(
            @RequestBody SettleElectronicAccountQuotaProvisionQueryDto queryDto);

    /**
     * 根据给定金额查询并计算出还款信息
     *
     * @param linkCode the link code
     * @param amount   the amount
     * @return repaid credit provision list
     */
    @GetMapping("/electronic/settleElectronicAccountQuotaProvision/getRepaidCreditProvisionList")
    Response<RepaidCreditProvisionResultDto> getRepaidCreditProvisionList(
            @RequestParam("linkCode") String linkCode, @RequestParam("amount") BigDecimal amount);
    // =========  end of  电子账户 模块 by ranxiangfu  ===========

    /**
     * 电子账户列表
     *
     * @param linkCode        the link code
     * @param sortCodeList    the sort code list
     * @param linkType        the link type
     * @param acctCode        the acct code
     * @param quotaMode       the quota mode
     * @param status          the status
     * @param dataPermissions the data permissions
     * @param limit           the limit
     * @param page            the page
     * @return page table
     */
    @GetMapping("/electronic/settleElectronicAccountInfo/accoutQueryPage")
    PageTable<SettleElectronicAccountInfo> accoutQueryPage(@RequestParam(value = "linkCode",required = false) String linkCode,
                                                           @RequestParam(value = "sortCodeList", required = false) List<String> sortCodeList,
                                                           @RequestParam(value = "linkType",required = false) String linkType,
                                                           @RequestParam(value = "acctCode",required = false) String acctCode,
                                                           @RequestParam(value = "quotaMode",required = false) String quotaMode,
                                                           @RequestParam(value = "status",required = false) String status,
                                                           @RequestParam(value = "dataPermissions", required = false) List<String> dataPermissions,
                                                           @RequestParam(value = "limit", defaultValue = "20") Integer limit,
                                                           @RequestParam(value = "page", defaultValue = "1") Integer page);

    /**
     * 账户告警设置列表-后台
     *
     * @param linkCode        the link code
     * @param linkType        the link type
     * @param acctCode        the acct code
     * @param status          the status
     * @param dataPermissions the data permissions
     * @param limit           the limit
     * @param page            the page
     * @return page table
     */
    @GetMapping("/electronic/settleElectronicAccountInfo/accoutQueryPageWithWarning")
    PageTable<SettleElectronicAccountInfo> accoutQueryPageWithWarning(@RequestParam(value = "linkCode",required = false) String linkCode,
                                                                      @RequestParam(value = "linkType",required = false) String linkType,
                                                                      @RequestParam(value = "acctCode",required = false) String acctCode,
                                                                      @RequestParam(value = "status",required = false) String status,
                                                                      @RequestParam(value = "dataPermissions", required = false) List<String> dataPermissions,
                                                                      @RequestParam(value = "limit", defaultValue = "20") Integer limit,
                                                                      @RequestParam(value = "page", defaultValue = "1") Integer page);

    /**
     * 根据linkCode查询对应的电子账户是否达到预警, 没有则返回空
     * @param linkCode
     * @return
     */
    @GetMapping("/electronic/settleElectronicAccountInfo/elecAcctBalanceWarningCheck")
    Response<SettleElectronicAccountInfo> elecAcctBalanceWarningCheck(@RequestParam(value = "linkCode") String linkCode);

    /**
     * 查询指定用户下的所有达到预警的电子账户信息
     * @param username
     * @return
     */
    @GetMapping("/electronic/settleElectronicAccountInfo/elecAcctBalanceWarningCheckByUsername")
    Response<List<SettleElectronicAccountInfo>> elecAcctBalanceWarningCheckByUsername(@RequestParam(value = "username") String username);

    /**
     * Update status response.
     *
     * @param info the info
     * @return the response
     */
    @PostMapping("/electronic/settleElectronicAccountInfo/updateStatus")
    Response updateStatus(@RequestBody SettleElectronicAccountInfo info);

    /**
     * 新增、编辑
     *
     * @param settleElectronicAccountInfo the settle electronic account info
     * @return response
     */
    @PostMapping("/electronic/settleElectronicAccountInfo/createSettleElectronicAccountInfo")
    Response createSettleElectronicAccountInfo(@RequestBody SettleElectronicAccountInfo settleElectronicAccountInfo);

    /**
     * 根据code 查询电子账户明细
     *
     * @param acctCode the acct code
     * @return settle electronic account info by acct code
     */
    @GetMapping("/electronic/settleElectronicAccountInfo/getSettleElectronicAccountInfoByAcctCode")
    Response<SettleElectronicAccountInfo> getSettleElectronicAccountInfoByAcctCode(@RequestParam(value = "acctCode") String acctCode);

    /**
     * Page query settle electronic account log page table.
     *
     * @param acctCode the acct code
     * @param limit    the limit
     * @param page     the page
     * @return the page table
     */
    @GetMapping("/electronic/settle-electronic-account-log/pageQuery")
    PageTable<SettleElectronicAccountLog> pageQuerySettleElectronicAccountLog(
            @RequestParam(value = "acctCode") String acctCode,
            @RequestParam(value = "limit", defaultValue = "20") Integer limit,
            @RequestParam(value = "page", defaultValue = "1") Integer page);

    /**
     * 手工调额
     *
     * @param quotaManual the quota manual
     * @return response
     */
    @PostMapping("/electronic/settleElectronicAccountQuotaManual/adjustQuota")
    Response adjustQuota(@RequestBody SettleElectronicAccountQuotaManual quotaManual);

    /**
     * 备付金充值
     *
     * @param quotaProvision the quota provision
     * @return response
     */
    @PostMapping("/electronic/settleElectronicAccountQuotaProvision/adjustQuota")
    Response adjustQuotaProvision(@RequestBody SettleElectronicAccountQuotaProvision quotaProvision);

    /**
     * 备付金充值详情
     *
     * @param code the code
     * @return provision info by code
     */
    @GetMapping("/electronic/settleElectronicAccountInfo/getProvisionInfoByCode")
    Response<SettleElectronicAccountQuotaProvision> getProvisionInfoByCode(@RequestParam(value = "code") String code);

    /**
     * Delete electronic account by link code response.
     *
     * @param linkCode the link code
     * @return the response
     */
    @GetMapping("/electronic/settleElectronicAccountInfo/deleteElectronicAccountByLinkCode")
    Response deleteElectronicAccountByLinkCode(@RequestParam(value = "linkCode") String linkCode);

    /**
     * 清除指定电子账户的 订单扣款、退款 所有相关数据，回退所有金额，保留电子账户的充值记录.
     * <p>
     * 这个接口很危险，不要乱调用！！！ 仅供在主体迁移所属合作客户的时候使用!
     *
     * @param sourceLinkCode the source link code
     * @param targetLinkCode the target link code
     * @return response response
     */
    @GetMapping("/electronic/settleElectronicAccountInfo/resetElectronicAccountBalanceByLinkCode")
    Response<String> resetElectronicAccountBalanceByLinkCode(@RequestParam("sourceLinkCode") String sourceLinkCode,
                                                             @RequestParam("targetLinkCode") String targetLinkCode);
    // =========  start of  收款记录 by ranxiangfu  ===========

    /**
     * 收款记录分页查询.
     *
     * @param pageQuery the page query
     * @return the page table
     */
    @PostMapping("/electronic/settle-electronic-account-collection-record/pageQuery")
    PageTable<SettleElectronicAccountCollectionRecord> electronicAccountCollectionRecordPageTable(
            @RequestBody ElectronicAccountCollectionRecordPageQuery pageQuery);

    /**
     * 保存收款记录.
     *
     * @param record the record
     * @return the response
     */
    @PostMapping("/electronic/settle-electronic-account-collection-record/save")
    Response saveElectronicAccountCollectionRecord(@RequestBody SettleElectronicAccountCollectionRecord record);

    /**
     * 根据收款记录编号查询收款记录详情.
     *
     * @param recordCode the record code
     * @return the electronic account collection record detail
     */
    @GetMapping("/electronic/settle-electronic-account-collection-record/detail")
    Response<SettleElectronicAccountCollectionRecordWithDetail> getElectronicAccountCollectionRecordDetail(
            @RequestParam("recordCode") String recordCode);

    /**
     * 根据业务编号查询收款明细.(备付金-借款授信-详情页用).
     *
     * @param bizCode the biz code
     * @return the response
     */
    @GetMapping("/electronic/settle-electronic-account-collection-record/listDetailByBizCode")
    Response<List<SettleElectronicAccountCollectionRecordDetail>> listElectronicAccountCollectionRecordDetailByBizCode(
            @RequestParam("bizCode") String bizCode);

    /**
     * 根据收款单号更新结息日期
     *
     * @param dto the dto
     * @return response
     */
    @PostMapping("/electronic/settle-electronic-account-collection-record/updateInterestEndDateByCollection")
    Response<Integer> updateInterestEndDateByCollection(@RequestBody UpdateInterestEndDateByCollectionDto dto);

    // =========  end of  收款记录 by ranxiangfu  ===========

    // =========  start of  发放主体收款记录 by ranxiangfu  ===========

    /**
     * Sets issuing body collection record pag query.
     *
     * @param pageQuery the page query
     * @return the issuing body collection record pag query
     */
    @PostMapping("/settle/settleIssuingBodyCollectionRecord/pageQuery")
    PageTable<SettleIssuingBodyCollectionRecord> settleIssuingBodyCollectionRecordPagQuery(
            @RequestBody SettleIssuingBodyCollectionRecordPageQuery pageQuery);

    /**
     * Sets issuing body collection record item pag query.
     *
     * @param pageQuery the page query
     * @return the issuing body collection record pag query
     */
    @PostMapping("/settle/settleIssuingBodyCollectionRecord/item/pageQuery")
    PageTable<SettleIssuingBodyCollectionRecordItem> settleIssuingBodyCollectionRecordItemPagQuery(
            @RequestBody SettleIssuingBodyCollectionRecordPageQuery pageQuery);

    /**
     * Save or update settle issuing body collection record response.
     *
     * @param settleIssuingBodyCollectionRecord the settle issuing body collection record
     * @return the response
     */
    @PostMapping("/settle/settleIssuingBodyCollectionRecord/saveOrUpdate")
    Response saveOrUpdateSettleIssuingBodyCollectionRecord(
            @RequestBody SettleIssuingBodyCollectionRecord settleIssuingBodyCollectionRecord);

    /**
     * Update settle issuing body collection record response.
     *
     * @param settleIssuingBodyCollectionRecord the settle issuing body collection record
     * @return the response
     */
    @PostMapping("/settle/settleIssuingBodyCollectionRecord/updateByCode")
    Response updateSettleIssuingBodyCollectionRecord(
            @RequestBody SettleIssuingBodyCollectionRecord settleIssuingBodyCollectionRecord);

    /**
     * Gets settle issuing body collection record by code.
     *
     * @param code the code
     * @return the settle issuing body collection record by code
     */
    @GetMapping("/settle/settleIssuingBodyCollectionRecord/getByCode")
    Response<SettleIssuingBodyCollectionRecord> getSettleIssuingBodyCollectionRecordByCode(@RequestParam("code") String code);

    /**
     * Save batch settle issuing body collection record detail response.
     *
     * @param detailList the detail list
     * @return the response
     */
    @PostMapping("/settle/settleIssuingBodyCollectionRecordDetail/saveBatch")
    Response saveBatchSettleIssuingBodyCollectionRecordDetail(
            @RequestBody List<SettleIssuingBodyCollectionRecordSettleDetail> detailList);

    /**
     * Start process settle issuing body collection record response.
     *
     * @param code                 the code
     * @param itemCode             the item code
     * @param actionUser           the action user
     * @return the response
     */
    @GetMapping("/settle/settleIssuingBodyCollectionRecord/startProcess")
    Response<List<SettleIssuingBodyCollectionRecordProcessInfo>> startProcessSettleIssuingBodyCollectionRecord(
            @RequestParam("code") String code,
            @RequestParam("itemCode") String itemCode,
            @RequestParam("actionUser") String actionUser);

    /**
     * 保存结算结果.
     *
     * @param settledResultSaveDto the settled result save dto
     * @return the response
     */
    @PostMapping("/settle/settleIssuingBodyCollectionRecord/saveSettledResult")
    Response saveIssuingBodyCollectionSettledResult(@RequestBody SettledResultSaveDto settledResultSaveDto);

    /**
     * Revert settle issuing body collection record status response.
     *
     * 回退主体的所有收款记录状态为未处理
     *
     * @param paramDto param dto
     * @return the response
     */
    @PostMapping("/settle/settleIssuingBodyCollectionRecord/revertStatus")
    Response<List<String>> revertSettleIssuingBodyCollectionRecordStatus(@RequestBody IssuingCustomerAndProductParamDto paramDto);
    // =========  end of  发放主体收款记录 by ranxiangfu  ===========


    // =========  start of  服务商发票管理 by huangdeyi  ===========
    /**
     * 分页查询开票事项
     * @param searchDto
     * @return
     */
    @PostMapping("/api/agent/invoice/matter/list")
    PageTable<SettleInvoiceMatter> selectAgentInvoiceMatterList(@SpringQueryMap InvoiceMatterSearchDto searchDto);

    /**
     * 根据开票事项获取开票事项详情
     * @param code
     * @return
     */
    @GetMapping("/api/agent/invoice/matter/detail/{code}")
    Response<InvoiceMatterDetailRespDto> getAgentInvoiceMatterDetailByCode(@PathVariable("code") String code);

    /**
     * 新增或更新开票事项
     * @param invoiceMatterReq
     * @return
     */
    @PostMapping("/api/agent/invoice/matter/addOrUpdate")
    Response addOrUpdateAgentInvoiceMatter(@RequestBody InvoiceMatterReqDto invoiceMatterReq);

    /**
     * 取消事项
     * @param req
     * @return
     */
    @PostMapping("/api/agent/invoice/matter/cancel")
    Response cancelAgentInvoiceMatter(@RequestBody InvoiceMatterCancelReq req);

    /**
     * 确认已全部开票
     * @param req
     * @return
     */
    @PostMapping("/api/agent/invoice/matter/confirm")
    Response confirmKPMatter(@RequestBody InvoiceMatterConfirmKPReq req);

    /**
     * 根据code删除开票事项
     * @param code
     * @return
     */
    @PostMapping("/api/agent/invoice/matter/del/{code}")
    Response deleteInvoiceMatterByCode(@PathVariable("code") String code);

    /**
     * 分页查询发票列表
     * @param searchDto
     * @return
     */
    @PostMapping("/api/agent/invoice/matter/invoice/list")
    PageTable<InvoiceMatterInvoicePageListRespDto> searchInvoicePage(@SpringQueryMap InvoiceMatterSearchDto searchDto);

    /**
     * 根据发票code获取发票详情
     * @param code 为发票的唯一流水号
     * @return
     */
    @GetMapping("/api/agent/invoice/matter/invoice/detail/{code}")
    Response<InvoiceMatterInvoiceDetailRespDto> getInvoiceDetailByCode(@PathVariable("code") String code);

    /**
     * 更新或批量更新发票寄送信息
     * @param invoiceMatterSendReq
     * @return
     */
    @PostMapping("/api/agent/invoice/matter/invoice/updateInvoiceSendInfo")
    Response updateInvoiceSendInfo(@RequestBody @Validated InvoiceMatterSendReqDto invoiceMatterSendReq);

    /**
     * 发票作废
     * @param req
     * @return
     */
    @PostMapping("/api/agent/invoice/matter/invoice/updateInvoiceToVoidInfo")
    Response updateInvoiceToVoidInfo(@RequestBody @Validated InvoiceMatterInvoiceToVoidReqDto req);

    /**
     * 收款单关联发票
     * @param updateReceiptReq
     * @return
     */
    @PostMapping("/api/agent/invoice/matter/invoice/updateReceipt")
    Response updateAgentInvoiceMatterReceipt(@RequestBody UpdateReceiptReqDto updateReceiptReq);

    // =========  end of  服务商发票管理 by huangdeyi  ===========


    /**
     * huhl
     * 根据代理Code 构建一个结算主体树，数据权限管理时用
     * @param agentCode
     * @return
     */
    @RequestMapping("/api/settle/subject/getDPSettleSubjectTreeByAgentCode")
    Response<List<DPSettleSubjectTreeDto>> getDPSettleSubjectTreeByAgentCode(@RequestParam("agentCode") String agentCode);

    // =========  start of  电子账户预警用户设置 by ranxiangfu  ===========

    /**
     * List elec acct warning username response.
     *
     * @param acctCode the acct code
     * @return the response
     */
    @GetMapping("/electronicaccount/settle-electronic-account-warning-user/listUsernameByAcctCode")
    Response<List<String>> listElecAcctWarningUsername(@RequestParam("acctCode") String acctCode);

    /**
     * Update elec acct warning user response.
     *
     * @param dto the dto
     * @return the response
     */
    @PostMapping("/electronicaccount/settle-electronic-account-warning-user/updateWarningUser")
    Response<String> updateElecAcctWarningUser(@RequestBody ElectronicAccountWarningUserUpdateDto dto);

    /**
     * Delete elec acct warning user response.
     *
     * @param acctCode the acct code
     * @param username the username
     * @return the response
     */
    @DeleteMapping("/electronicaccount/settle-electronic-account-warning-user/deleteWarningUser")
    Response<String> deleteElecAcctWarningUser(@RequestParam("acctCode") String acctCode,
                                               @RequestParam("username") String username);

    // =========  end of  电子账户预警用户设置 by ranxiangfu  ===========

    // =========  start of  操作冻结金额 by yinshihao  ===========
    /**
     * 操作冻结金额
     *
     * @param req
     * @return
     */
    @PostMapping("/api/settle/account/settleAccountOperationFreezeAmountLog/operationFreezeAmount")
    Response<TradeResp> operationFreezeAmount(@RequestBody @Validated OperationFreezeAmountReq req);

    // =========  end of  操作冻结金额 by yinshihao  ===========

    /**
     * 发票详情
     * @param code
     * @return
     */
    @GetMapping("/api/agent/invoice/matter/invoice/detail/{code}")
     Response<InvoiceMatterInvoiceDetailRespDto> getAgentInvoiceMatterInvoiceDetailByCode(@PathVariable("code") String code);
}
