package com.rocogz.syy.settlement.dto;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>操作冻结金额请求实体类</p>
 * @author yinshihao
 * @date 2022/07/07
 */
@Data
@Accessors(chain = true)
public class OperationFreezeAmountReq {

    /**
     * 业务编号
     */
    @NotBlank
    private String businessNo;

    /**
     * 修改后金额
     */
    @NotNull
    @DecimalMin("0.01")
    @Digits(integer = 12,fraction = 3,message = "修改后金额有误")
    private BigDecimal afterAmount;

    /**
     * 创建人
     */
    @NotBlank
    private String createUser;

    /**
     * 创建时间
     */
    @NotNull
    private LocalDateTime createTime;
}
