package com.rocogz.syy.settlement.entity.account;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 账户交易操作冻结金额日志表
 * </p>
 *
 * @author yinshihao
 * @since 2022-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("settle_account_operation_freeze_amount_log")
public class SettleAccountOperationFreezeAmountLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 业务编号
     */
    private String businessNo;

    /**
     * 修改前金额
     */
    private BigDecimal beforeAmount;

    /**
     * 修改后金额
     */
    private BigDecimal afterAmount;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


}
