package com.rocogz.syy.settlement.entity.invoicematter;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.settlement.enums.invoicematter.AgentInvoiceMatterStatusEnum;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Description: 新增开票事项实体类
 * @date：2021/9/8
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("settle_invoice_matter")
public class SettleInvoiceMatter extends IdEntity {

    private static final long serialVersionUID = 477447239518274241L;

    /**
    * 编码
    */
    private String code;
    
    /**
    * 服务商编号
    */
    private String agentCode;
    
    /**
    * 发放主体编号
    */
    private String issuingBodyCode;
    
    /**
    * 结算主体编号
    */
    private String settleSubjectCode;
    
    /**
    * 业务归属年份
    */
    private String businessYear;
    
    /**
    * 业务归属月份
    */
    private String businessMonth;
    
    /**
    * 开票事项备注
    */
    private String matterRemark;

    /**
     * 应开发票数量
     */
    public Integer needInvoiceNum;

    /**
     * 应开发票含税金额
     */
    public BigDecimal needInvoiceIncludeTaxAmount;

    /**
     * 已开发票数量
     */
    public Integer haveInvoiceNum;

    /**
     * 已开发票含税金额
     */
    public BigDecimal haveInvoiceIncludeTaxAmount;

    /**
     * 未开发票数量  needInvoiceNum-haveInvoiceNum
     */
    public Integer leftInvoiceNum;

    /**
     * 未开发票含税金额 needInvoiceIncludeTaxAmount-haveInvoiceIncludeTaxAmount
     */
    public BigDecimal leftInvoiceIncludeTaxAmount;

    /**
     * 作废的发票数量  当作废发票时候更新
     */
    public Integer voidedInvoiceNum;

    /**
     * 作废的发票含税金额。 当作废发票时候更新
     */
    public BigDecimal voidedInvoiceIncludeTaxAmount;

    /**
    * 取消日期
    */
    private LocalDateTime cancelTime;
    
    /**
    * 取消备注
    */
    private String cancelRemark;
    
    /**
    * 事项状态（字典类型：AGENT_INVOICE_MATTER_STATUS）
     * @see AgentInvoiceMatterStatusEnum
    */
    private String status;

    /**
    * 创建人
    */
    private String createUser;
    
    /**
    * 创建时间
    */
    private LocalDateTime createTime;
    
    /**
    * 更新人
    */
    private String updateUser;
    
    /**
    * 更新时间
    */
    private LocalDateTime updateTime;
}