package com.rocogz.syy.settlement.entity.invoicematter;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.settlement.enums.invoicematter.AgentInvoiceMatterInvoiceStatusEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:发票事项 </dd>
 * <dd>@date: 2022/10/12</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
@TableName("settle_invoice_matter_invoice_detail")
public class SettleInvoiceMatterInvoiceDetail  extends IdEntity {


    private static final long serialVersionUID = 6936268714120017684L;

    /**
     * 发票的唯一流水号：发号器生成
     */
    private String code;

    /**
     * 开票事项编码
     */
    private String matterCode;

    /**
     * 发票代码 和 发票号码 是唯一索引
     */
    private String invoiceCode;

    /**
     * 发票号码
     */
    private String invoiceNo;

    /**
     * 发票唯一性标识
     */
    private String invoiceUniqueFlag;

    /**
     * 付款方
     */
    private String payer;

    /**
     * 收款方
     */
    private String payee;

    /**
     * 发票类型：
     */
    private String invoiceType;

    /**
     * 发票税率
     */
    private BigDecimal invoiceTaxRate;

    /**
     * 发票金额
     */
    private BigDecimal invoiceAmount;

    /**
     * 发票税额
     */
    private BigDecimal invoiceTaxAmount;

    /**
     * 发票含税金额
     */
    private BigDecimal invoiceIncludeTaxAmount;

    /**
     * 开票时间
     */
    private LocalDate invoicingTime;

    /**
     * 发票图片
     */
    private String invoiceImagePath;

    /**
     * 发票说明
     */
    private String invoiceRemark;

    /**
     * 送达方式
     */
    private String deliveryWay;

    /**
     * 快递单号
     */
    private String courierNo;

    /**
     * 快递公司
     */
    private String courierCompany;

    /**
     * 快递发出日期
     */
    private LocalDate courierSendTime;

    /**
     * 快递送达日期
     */
    private LocalDate courierReceiveTime;

    /**
     * 送票人姓名
     */
    private String distributor;

    /**
     * 送票人手机号
     */
    private String distributorMobile;

    /**
     * 接收人姓名
     */
    private String receiver;

    /**
     * 接收人手机号
     */
    private String receiverMobile;

    /**
     * 快递单截图
     */
    private String courierImagePath;

    /**
     * 送达凭证
     */
    private String deliveryImagePath;

    /**
     * 寄送备注
     */
    private String deliveryRemark;

    /**
     * 作废日期
     */
    private LocalDate toVoidTime;

    /**
     * 作废备注
     */
    private String toVoidRemark;

    /**
     * 发票状态（字典类型：AGENT_INVOICE_MATTER_INVOICE_STATUS）
     * @see AgentInvoiceMatterInvoiceStatusEnum
     */
    private String status;

    /**
     * 收款单号:发放主体收款登录选择发票，会将收款单号返填到这里
     */
    private String receiptCode;

    /**
     * 收款到账日期
     */
    private LocalDate receiptTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

}
