package com.rocogz.syy.settlement.enums;

/**
 * <p>发号器类型枚举</p>
 * @author djt
 * @date 2021/4/8
 */
public enum SerialNoTypeEnum {

    /**
     * 账户操作日志
     */
    ACCOUNT_TRADE_LOG("账户操作日志编码"),

    /**
     * 发放主体账户发号器编码
     */
    ISSUING_BODY_ACCOUNT_CODE("发放主体账户编码"),

    /**
     * 团队账户编码
     */
    TEAM_ACCOUNT_CODE("团队账户编码"),

    /**
     * 个人账户编码
     */
    PERSON_ACCOUNT_CODE("个人账户编码"),

    /**
     * 账户增加调整流水编号
     */
    ACCOUNT_ADD_ADJUST_RECORD_CODE("账户增加调整流水编号"),


    /**
     * 账户减少调整流水编号
     */
    ACCOUNT_REDUCE_ADJUST_RECORD_CODE("账户减少调整流水编号"),


    /**
     * 账户流水编号
     */
    ACCOUNT_TRADE_RECORD_CODE("账户交易流水编号")



    ;



    private String label;

    SerialNoTypeEnum(String label) {
        this.label = label;
    }

    public String getLabel() {
        return label;
    }

}
