package com.rocogz.syy.settlement.dto;

import lombok.Data;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author djt
 * @date 2021/6/24
 */
@Data
public class AccountCrossLevelAllocateItem {


    /**
     * 划入账户编号
     */
    @NotBlank(message = "划入目标不能为空")
    private String toSubject;


    /**
     * 划拨金额
     */
    @NotNull(message = "划拨金额")
    @Digits(integer=12,fraction = 3)
    @DecimalMin(value = "0.001",message = "划拨金额不能小于0.001元")
    private BigDecimal amount;


}
