package com.rocogz.syy.settlement.dto;

import com.rocogz.syy.settlement.enums.AccountCrossLevelAllocateTypeEnum;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author djt
 * @date 2021/6/24
 */
@Data
public class AccountCrossLevelAllocateParam  {

    @Valid
    @NotEmpty
    List<AccountCrossLevelAllocateItem> itemList;

    /**
     * 划出发放主体编号
     */
    @NotBlank(message = "划出发放主体不能为空")
    private String fromSubject;

    /**
     * 划拨类型
     */
    @NotNull(message = "划拨类型不能为空")
    private AccountCrossLevelAllocateTypeEnum  allocateType;


}
