package com.rocogz.syy.settlement.dto.invoicematter;

import lombok.Data;

import java.util.List;

/**
 * @Description: 开票事项查询dto
 * @date：2021/9/8
 * @author：huangdeyi
 */
@Data
public class InvoiceMatterSearchDto {

    /**
     * 开票事项编号
     */
    private String matterCode;

    /**
     * 服务商code列表
     */
    private List<String> agentCodes;

    /**
     * 发放主体code列表
     */
    private List<String> issuingBodyCodes;

    /**
     * 结算主体code列表
     */
    private List<String> settleSubjectCodes;

    /**
     * 业务年份
     */
    private String businessYear;

    /**
     * 事项开票年份
     */
    private String invoicingYear;

    /**
     * 事项开票月份
     */
    private List<String> invoicingMonth;

    /**
     * 发票开票年份
     */
    private String invoiceInvoicingYear;

    /**
     * 发票开票月份
     */
    private List<String> invoiceInvoicingMonth;

    /**
     * 发票号码
     */
    private String invoiceNo;

    /**
     * 发票代码
     */
    private String invoiceCode;

    /**
     * 发票类型
     */
    private String invoiceType;

    /**
     * 收款单号
     */
    private String receiptCode;

    /**
     * 收款到账开始时间
     */
    private String receiptStartTime;

    /**
     *收款到账结束时间
     */
    private String receiptEndTime;

    /**
     * 开票开始时间
     */
    private String invoicingStartTime;

    /**
     * 开票结束时间
     */
    private String invoicingEndTime;

    /**
     * 事项状态
     */
    private String matterStatus;

    /**
     * 事项状态列表
     */
    private List<String> matterStatusList;

    /**
     * 发票状态
     */
    private String invoiceStatus;

    /**
     * 当前页
     */
    private int page;

    /**
     * 每页记录数
     */
    private int limit;
}
