package com.rocogz.syy.settlement.entity.electronicaccount;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;

import java.time.LocalDate;
import java.time.LocalDateTime;

import com.rocogz.syy.settlement.constant.SettlementConstant;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 电子账户收款记录表
 * </p>
 *
 * @author ranxiangfu
 * @since 2021-06-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SettleElectronicAccountCollectionRecord extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 收款记录编号
     */
    private String code;

    /**
     * 电子账户编码
     */
    private String acctCode;

    /**
     * 电子账户类型对应的编码
     */
    private String linkCode;

    /**
     * 电子账户关联类型(AGENT:代理商;CUSTOMER:合作客户)
     */
    private String linkType;

    /**
     * 是否归还借款
     * 针对的是备付金模式：只有备付金有授信充值和收款登记
     * 2022-10-31 调整
     * Y：走原来的逻辑
     * N：直接充值不走还款
     * @see SettlementConstant#COMMON_Y
     */
    private String enableReturnDebt;

    /**
     * 收款金额
     */
    private BigDecimal collectionAmount;

    /**
     * 归还借款金额
     */
    private BigDecimal debtUsedAmount;

    /**
     * 归还借款笔数
     */
    private Integer debtUsedCount;

    /**
     * 备付金充值金额
     */
    private BigDecimal reservePaymentUsedAmount;

    /**
     * 收款日期
     */
    private LocalDate collectionDate;

    /**
     * 收款凭证
     */
    private String collectionVoucherImg;

    /**
     * 有无归还借款
     */
    private Boolean hasDebt;

    /**
     * 有无充值备付金
     */
    private Boolean hasRecharge;

    /**
     * 收款备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    // ===============下面的字段只是为了在分销后台做显示================
    /**
     * 代理商编码
     */
    @TableField(exist = false)
    private String agentCode;

    /**
     * 代理商名称
     */
    @TableField(exist = false)
    private String agentName;

    /**
     * 合作客户编码
     */
    @TableField(exist = false)
    private String customerCode;

    /**
     * 合作客户简称
     */
    @TableField(exist = false)
    private String customerAbbreviation;

    /**
     * 合作客户类别
     */
    @TableField(exist = false)
    private String customerCategory;

    /**
     * 结算发放主体名称
     */
    @TableField(exist = false)
    private String settleIssuingBodyName;
}
