package com.rocogz.syy.settlement.entity.issuingbody.collection;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 发放主体收款记录订单结算明细表
 * </p>
 *
 * @author ranxiangfu
 * @since 2021-07-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SettleIssuingBodyCollectionRecordSettleDetail extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 收款记录编码
     */
    private String collectionRecordCode;

    /**
     * 收款记录明细编码
     */
    private String collectionRecordItemCode;

    /**
     * 处理批次号
     */
    private String processBatchCode;

    /**
     * 业务编号(分销订单编号)
     */
    private String bizCode;

    /**
     * 这笔业务的结算金额
     */
    private BigDecimal settledAmount;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;
}
