package com.rocogz.syy.settlement.dto.invoicematter;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @Description: 添加开票事项附件dto
 * @date：2021/9/8
 * @author：huangdeyi
 */
@Data
public class InvoiceMatterAttachDto {

    /**
     * 开票事项编码
     */
    @NotBlank
    private String invoiceMatterCode;
    /**
     *
     * 发票的唯一序列号 对应SettleInvoiceMatterInvoiceDetail.code
     */
    private String invoiceSnCode;

    /**
     * 目标类型：MATTER / INVOICE  这个附件是属于MATTER 还是 INVOICE
     */
    @NotBlank
    private String target;

    /**
     * 附件类型：MATTER-事项附件，TO_VOID-作废附件
     */
    @NotBlank
    private String type;

    /**
     * 文件名称
     */
    @NotBlank
    private String fileName;

    /**
     * 文件路径
     */
    @NotBlank
    private String filePath;

    /**
     * 文件说明
     */
    @Length(max = 100)
    private String fileRemark;
}
