package com.rocogz.syy.settlement.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 结算主体
 * </p>
 *
 * @author yifenrui
 * @since 2020-04-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "settle_subject")
public class SettleSubject extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 编号
     */
    private String code;

    /**
     * 名称
     */
    private String name;

    /**
     * 类型
     */
    private String type;

    /**
     * 备注
     */
    private String description;

    /**
     * 状态
     */
    private String status;

    /**
     * 简称
     */
    private String abbreviation;

    /**
     * 所属服务商编号
     */
    private String agentCode;

    /**
     * 所属服务商名称
     */
    @TableField(exist = false)
    private String agentName;

    /**
     * 所属服务商简称
     */
    @TableField(exist = false)
    private String agentAbbreviation;

    /**
     * 组织机构代码
     */
    private String organizationCode;

    /**
     * 纳税人识别号
     */
    private String identificationNumber;

    /**
     * 统一社会信用代码
     */
    private String creditCode;

    /**
     * 营业执照
     */
    private String businessLicensePath;

}
