package com.rocogz.syy.settlement.entity.electronicaccount;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 电子账户-备付金使用信息表
 * </p>
 *
 * @author ranxiangfu
 * @since 2021-06-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SettleElectronicAccountProvisionUsedInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 电子账户编码
     */
    private String acctCode;

    /**
     * 电子账户类型对应的编码
     */
    private String acctLinkCode;

    /**
     * 充值记录编号
     */
    private String rechargeCode;

    /**
     * 充值记录-充值类型
     *
     * 字典类型 ：ELECTRONIC_ACCT_PROVISION_TYPE
     *
     * 字典值：COLLECT:收款充值，CREDIT:授信充值
     */
    private String rechargeType;

    /**
     * 扣款流水编号
     */
    private String flowCode;

    /**
     * 扣款流水的业务编号
     */
    private String flowBizCode;

    /**
     * 流水类型(PAY:扣款;REFUND:退款)
     */
    private String transactionType;

    /**
     * 交易金额
     */
    private BigDecimal transactionAmount;

    /**
     * 借款利息费率
     */
    private BigDecimal interestRate;

    /**
     * 借款利息开始计算日期(含当日)
     */
    private LocalDate interestStartDate;

    /**
     * 借款利息结束计算日期(含当日)
     */
    private LocalDate interestEndDate;

    /**
     * 结息操作时间
     */
    private LocalDateTime interestEndOperateTime;

    /**
     * 结息操作人
     */
    private String interestEndOperateUser;
}
