package com.rocogz.syy.settlement.dto.invoicematter;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.settlement.entity.invoicematter.SettleInvoiceMatterInvoiceDetail;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description: 新增开票事项Dto
 * @date：2021/9/8
 * @author：huangdeyi
 */
@Data
public class InvoiceMatterReqDto {

    /**
     * 编码
     */
    private String code;

    /**
     * 前一个状态
     */
    private String preStatus;

    /**
     * 当前状态
     */
    @NotBlank(message = "事项状态不能为空")
    private String status;

    /**
     * 服务商编号
     */
    @NotBlank(message = "服务商编号不能为空")
    private String agentCode;

    /**
     * 发放主体编号
     */
    @NotBlank(message = "发放主体编号不能为空")
    private String issuingBodyCode;

    /**
     * 结算主体编号
     */
    @NotBlank(message = "结算主体编号不能为空")
    private String settleSubjectCode;

    /**
     * 业务归属年份
     */
    @NotBlank(message = "业务归属年份不能为空")
    private String businessYear;

    /**
     * 业务归属月份
     */
    private String businessMonth;

    /**
     * 开票年份
     */
    private String matterInvoicingYear;

    /**
     * 开票月份
     */
    private String matterInvoicingMonth;

    /**
     * 事项附件列表
     */
    private List<InvoiceMatterAttachDto> matterAttchs;

    /**
     * 开票事项备注
     */
    @Length(max = 200, message = "开票事项备注长度不能超过200")
    private String matterRemark;

    /**
     * 应开发票数量
     */
    @NotNull(message = "应开发票数量不能为空")
    @DecimalMin(value = "0", message = "应开发票数量需要大于0")
    public Integer needInvoiceNum;

    /**
     * 应开发票含税金额
     */
    @NotNull(message = "应开发票含税金额不能为空")
    @DecimalMin(value = "0", message = "应开发票含税金额需要大于0")
    public BigDecimal needInvoiceIncludeTaxAmount;

    /**
     * 已开发票数量
     */
    public Integer haveInvoiceNum;

    /**
     * 已开发票含税金额
     */
    public BigDecimal haveInvoiceIncludeTaxAmount;

    /**
     * 未开发票数量  needInvoiceNum-haveInvoiceNum
     */
    public Integer leftInvoiceNum;

    /**
     * 未开发票含税金额 needInvoiceIncludeTaxAmount-haveInvoiceIncludeTaxAmount
     */
    public BigDecimal leftInvoiceIncludeTaxAmount;

    /**
     * 发票详情列表
     */
    private List<SettleInvoiceMatterInvoiceDetail> invoiceDetails;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
