package com.rocogz.syy.settlement.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author 尹世豪
 * @Description: 账户查询请求dto
 * @Package com.rocogz.syy.dto.account
 * @date 2021/4/8 14:57
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
public class AccountOperationLogResDTO {
    private Boolean export = Boolean.FALSE;
    /**
     * 账户编号
     */
    @NotBlank(message = "账户编号不能为空")
    private String acctNo;

    /**
     * 目标账户类型(划出、自动划出操作有值)
     */
    private String toAcctType;

    /**
     * 操作日期开始时间,即划拨日期
     */
    private String createDateStart;

    /**
     * 操作日期结束时间,即划拨日期
     */
    private String createDateEnd;

    /**
     * 调整类型
     */
    private String allocateType;

    /**
     * 目标账户编号(划出、自动划出操作有值)
     */
    private String toAcctNo;

    /**
     * 团队编码
     */
    private String teamCode;

    /**
     * 姓名(basic_system_admin_user的name) 个人账户才有
     */
    private String personName;

    /**
     * 手机号(basic_system_admin_user的mobile) 个人账户才有
     */
    private String personMobile;

    private Integer page = 1;

    private Integer limit = 10;

}
