package com.rocogz.syy.settlement.dto.invoicematter;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @Description: 开票事项复制reqDto
 * @date：2021/9/24
 * @author：huangdeyi
 */
@Data
public class InvoiceMatterCopyReqDto {

    /**
     * 服务商编号
     */
    @NotBlank(message = "服务商编号不能为空")
    private String agentCode;

    /**
     * 发放主体编号
     */
    @NotBlank(message = "发放主体编号不能为空")
    private String issuingBodyCode;

    /**
     * 结算主体编号
     */
    @NotBlank(message = "结算主体编号不能为空")
    private String settleSubjectCode;

    /**
     * 业务归属年份
     */
    @NotBlank(message = "业务归属年份不能为空")
    private String businessYear;

    /**
     * 业务归属月份
     */
    private String businessMonth;

    /**
     * 开票事项备注
     */
    @Length(max = 200, message = "开票事项备注长度不能超过200")
    private String matterRemark;

    /**
     * 发票代码
     */
    @NotBlank(message = "发票代码不能为空")
    private String invoiceCode;

    /**
     * 发票号码
     */
    @NotBlank(message = "发票号码不能为空")
    private String invoiceNo;

    /**
     * 付款方
     */
    @NotBlank(message = "付款方不能为空")
    private String payer;

    /**
     * 收款方
     */
    @NotBlank(message = "收款方不能为空")
    private String payee;

    /**
     * 发票类型
     */
    @NotBlank(message = "发票类型不能为空")
    private String invoiceType;

    /**
     * 发票税率
     */
    @NotNull(message = "发票税率不能为空")
    @DecimalMin(value = "0", message = "发票税率需大于0")
    private BigDecimal invoiceTaxRate;

    /**
     * 开票日期
     */
    @NotNull(message = "开票日期不能为空")
    private LocalDate invoicingTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
