package com.rocogz.syy.settlement.entity.electronicaccount;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import java.util.List;

import com.rocogz.syy.settlement.entity.attachment.SettleAttachment;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author yifenrui
 * @since 2021-04-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("settle_electronic_account_quota_manual")
public class SettleElectronicAccountQuotaManual extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 业务单号
     */
    private String code;

    /**
     * 电子账户code
     */
    private String acctCode;

    /**
     * 调整类型：INCREASE:增加,  REDUCE:减少
     */
    private String type;

    /**
     * 电子账户-虚拟额度-变化额度
     */
    private BigDecimal quota;

    /**
     * 额度账户-变化额度(和上面的虚拟额度 通过 额度转换比例 互相转化)
     */
    private BigDecimal settleAccountQuota;

    /**
     * 调整凭证
     */
    private String voucherImg;

    /**
     * 备注
     */
    private String remark;

    /**
     * 操作时间
     */
    private LocalDateTime createTime;

    /**
     * 操作人
     */
    private String createUser;

    @TableField(exist = false)
    private String linkCode;

    /**
     * 调整类型-名称
     */
    @TableField(exist = false)
    private String typeName;

    /**
     * 附件列表
     */
    @TableField(exist = false)
    private List<SettleAttachment> attachmentList;

    /**
     * 后台页面手工调整的列表中凭证里面有个查看附件按钮,
     * 之前是只传递一个并且也是非必填,2023.02.10调整为了多个附件，为了控制
     * 在查询列表的时候统计下附件的数量,但是导出的时候不再统计
     */
    @TableField(exist = false)
    private Long attachmentCount;

}
