package com.rocogz.syy.settlement.entity.electronicaccount;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:结算电子账户第三方申请关系 </dd>
 * <dd>@date: 2023/02/17</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("settle_electronic_account_third_quota_apply_rel")
public class SettleElectronicAccountThirdQuotaApplyRel extends IdEntity {

    /**
     * 第三方的业务单号
     *
     * 已知道:
     * 车服后台，小程序的额度调整申请单号
     *
     * 主要是做幂等判断，不动现系统
     */
    private String thirdBizNo;

    /**
     * 自己的单号：
     * 手动调整单据号，授信充值的单号，收款充值的收款记录号
     */
    private String selfBizNo;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

}
