package com.rocogz.syy.settlement.dto.datapermission;

import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * <dl>
 * <dd>Description:数据权限结算主体树,前台使用了dtree构建树 </dd>
 * <dd>@date: 2021/09/23</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Getter
@Setter
public class DPSettleSubjectTreeDto {

    private static final long serialVersionUID = 4307848078425771330L;

    public DPSettleSubjectTreeDto(){
        spread =true;
    }
    /**
     * 可以认为就是code和数据权限中的data_type的组合
     */
    private String id;
    /**
     * 级别
     */
    private Integer level;
    /**
     * 标题
     */
    private String title;

    /**
     * 是否展开
     */
    private Boolean spread;

    /**
     * 节点的状态状态，看是否启用，前台没启用的会变颜色
     */
    private String status;

    /**
     * 孩子
     */
    private List<DPSettleSubjectTreeDto> children;

    /**
     * Dtree必须的
     */
    private DtreeCheckArr checkArr = new DtreeCheckArr();

    /**
     * 结算主体的Code
     */
    private String code;
    /**
     * 结算主体的数据权限类型，在admin端进行了填充
     */
    private String dataType;

}
