package com.rocogz.syy.settlement.dto.electronic.account;

import com.rocogz.syy.settlement.constant.SettlementConstant;
import com.rocogz.syy.settlement.entity.attachment.SettleAttachment;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import java.time.LocalDate;
import java.util.List;

/**
 * <dl>
 * <dd>Description:对进行扩展
 * 已知场景：
 * 车服后台，小程序端调整</dd>
 * <dd>@date: 2023/02/11</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class OperateElectronicAcctExtend extends OperateElectronicAcct {

    /**
     * 账户 额度管理模式
     *
     * 申请调整的额度管理模式 可能与当前账户的额度管理模式不匹配
     * 增加传递参数 也是为了校验下
     *
     * @see SettlementConstant.ElectronicAccountQuotaMode
     */
    @NotEmpty
    private String quotaMode;

    /**
     * 收款到账日期 如果是备付金模式 收款充值则 传递
     */
    private LocalDate collectionDate;

    /**
     * 附件列表,对于车服后台的 额度申请单凭证
     */
    private List<SettleAttachment> attachmentList;


}
