package com.rocogz.syy.settlement.dto.invoicematter.invoice;

import com.rocogz.syy.settlement.dto.invoicematter.InvoiceMatterAttachDto;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description:发票作废请求 </dd>
 * <dd>@date: 2022/10/13</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class InvoiceMatterInvoiceToVoidReqDto {

    /**
     * 发票的唯一流水号
     */
    @NotBlank(message = "发票的唯一流水号不能为空")
    private String code;

    /**
     * 作废日期
     */
    @NotNull(message = "作废日期不能为空")
    private LocalDate toVoidTime;

    /**
     * 作废备注
     */
    @Length(max = 200, message = "作废备注长度不能超过200")
    private String toVoidRemark;

    /**
     * 作废附件列表
     */
    private List<InvoiceMatterAttachDto> attachs;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
