package com.rocogz.syy.settlement.entity.electronicaccount;

import java.math.BigDecimal;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 电子账户-备付金使用信息表
 * </p>
 *
 * @author ranxiangfu
 * @since 2021-06-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SettleElectronicAccountProvisionUsedInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 电子账户编码
     */
    private String acctCode;

    /**
     * 电子账户类型对应的编码
     */
    private String acctLinkCode;

    /**
     * 充值记录编号
     */
    private String rechargeCode;

    /**
     * 扣款流水编号
     */
    private String flowCode;

    /**
     * 流水类型(PAY:扣款;REFUND:退款)
     */
    private String transactionType;

    /**
     * 交易金额
     */
    private BigDecimal transactionAmount;
}
