package com.rocogz.syy.settlement.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author 尹世豪
 * @Description:
 * @Package com.rocogz.dto.account
 * @date 2021/7/6 14:33
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
public class AccountRequestDto {
    /**
     * 上级发放主体编号.
     */
    @NotBlank(message = "上级发放主体编号不能为空")
    private String pIssuingBodyCode;

    /**
     * 是否开启代理人价格.
     */
    private List<String> issuingBodyCodeList;

    /**
     * 排序类型.
     */
    private String sortType;

    /**
     *  每页多少条
     */
    private int limit = 15;

    /**
     * 第几页
     */
    private int page = 1;
}
