package com.rocogz.syy.settlement.dto.electronic.account;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021/6/2 17:50</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class ElectronicAccountCollectionRecordPageQuery {
    /**
     * 收款单号.
     */
    private String code;

    /**
     * 电子账户关联的代理商编号或者客户编号.
     */
    private String linkCodeStr;

    /**
     * 电子账户关联的代理商编号或者客户编号.
     */
    private List<String> linkCodeList;

    /**
     * 电子账户的关联类型(AGENT/CUSTOMER)
     */
    private String linkType;

    /**
     * 收款日期-开始时间.
     */
    private String collectionDateStartTime;

    /**
     * 收款日期-结束时间.
     */
    private String collectionDateEndTime;

    /**
     * 登记日期-开始时间.
     */
    private String createTimeStartTime;

    /**
     * 登记日期-结束时间.
     */
    private String createTimeEndTime;

    /**
     * 有无归还借款.
     */
    private Boolean hasDebt;

    /**
     * 有无充值备付金.
     */
    private Boolean hasRecharge;

    /**
     * 合作客户所属代理商编码列表
     */
    private String belongAgentCodeStr;

    /**
     * 合作客户所属代理商编码列表
     */
    private List<String> belongAgentCodeList;

    /**
     * 额度申请单号
     */
    private String quotaApplyCode;

    /**
     * 是否是导出.
     */
    private Boolean export = Boolean.FALSE;

    private Integer page;

    private Integer limit;
}
