package com.rocogz.syy.settlement.dto.electronic.account;

import lombok.Data;

import java.util.List;

/**
 * <dl>
 * <dd>Description:电子账户分页查询的DTO
 *
 * 将单个参数 转化为对象
 *
 * 保持原来的不变新增接口使用
 *
 * 已知场景：
 * 1.admin后台分页检索
 *
 * </dd>
 * <dd>@date: 2023/03/14</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
public class ElectronicAccountPageQuery {


    /**
     * 代理商/合作客户编码
     */
    private String linkCode ;

    /**
     * linkCodeList
     */
    private List<String> sortCodeList;

    /**
     * 代理商/合作客户编码 集合
     */
    private List<String> linkCodeList;

    /**
     * 账户类型
     */
    private String linkType;

    /**
     * 电子账户编号
     */
    private String acctCode;

    /**
     * 额度管理模式
     */
    private String quotaMode;

    /**
     * 状态
     */
    private String status;

    /**
     * 数据权限
     */
    private List<String>  dataPermissions;


    private int limit = 20;

    private int page = 1;



}
