package com.rocogz.syy.settlement.dto.invoicematter;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description: 添加开票事项寄送信息Dto
 * @date：2021/9/8
 * @author：huangdeyi
 */
@Data
public class InvoiceMatterSendReqDto {

    /**
     * 开票事项code列表
     */
    @Valid
    @NotEmpty(message = "发票的唯一序号")
    private List<String> codes;

    /**
     * 送达方式
     */
    @NotBlank(message = "送达方式不能为空")
    private String deliveryWay;

    /**
     * 快递单号
     */
    private String courierNo;

    /**
     * 快递公司
     */
    private String courierCompany;

    /**
     * 快递发出日期
     */
    private LocalDate courierSendTime;

    /**
     * 快递送达日期
     */
    private LocalDate courierReceiveTime;

    /**
     * 送票人姓名
     */
    private String distributor;

    /**
     * 送票人手机号
     */
    private String distributorMobile;

    /**
     * 接收人姓名
     */
    private String receiver;

    /**
     * 接收人手机号
     */
    private String receiverMobile;

    /**
     * 快递单截图
     */
    private String courierImagePath;

    /**
     * 送达凭证
     */
    private String deliveryImagePath;

    /**
     * 寄送备注
     */
    @Length(max = 200, message = "寄送备注长度不能大于200")
    private String deliveryRemark;

    /**
     * 操作：
     */
    private String action;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
