package com.rocogz.syy.settlement.dto.invoicematter.invoice;

import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:发票的分页列表 </dd>
 * <dd>@date: 2022/10/12</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class InvoiceMatterInvoicePageListRespDto {

    /**
     * 事项编号
     */
    private String matterCode;

    /**
     * 服务商编号
     */
    private String agentCode;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 结算主体编号
     */
    private String settleSubjectCode;

    /**
     * 业务归属年份
     */
    private String businessYear;

    /**
     * 业务归属月份
     */
    private String businessMonth;

    /**
     * 开票事项备注
     */
    private String matterRemark;

    /**
     * 终止日期
     */
    private LocalDate toStopTime;

    /**
     * 终止备注
     */
    private String toStopRemark;

    /**
     * 事项状态（字典类型：AGENT_INVOICE_MATTER_STATUS）
     * @see AgentInvoiceMatterStatusEnum
     *
     * @see SettleInvoiceMatter.status
     */
    private String matterStatus;

    /**
     * 事项创建时间
     * @see SettleInvoiceMatter.createTime
     */
    private LocalDateTime matterCreateTime;

    //发票信息
    /**
     * 发票的唯一流水号：发号器生成
     * @see settle_invoice_matter_invoice_detail.code
     */
    private String code;


    /**
     * 发票代码 和 发票号码 是唯一索引
     */
    private String invoiceCode;

    /**
     * 发票号码
     */
    private String invoiceNo;

    /**
     * 付款方
     */
    private String payer;

    /**
     * 收款方
     */
    private String payee;

    /**
     * 发票类型：
     */
    private String invoiceType;

    /**
     * 发票税率
     */
    private BigDecimal invoiceTaxRate;

    /**
     * 发票金额
     */
    private BigDecimal invoiceAmount;

    /**
     * 发票税额
     */
    private BigDecimal invoiceTaxAmount;

    /**
     * 发票含税金额
     */
    private BigDecimal invoiceIncludeTaxAmount;

    /**
     * 开票时间
     */
    private LocalDate invoicingTime;

    /**
     * 开票年份: 取 invoicingTime 的 year
     */
    private String invoicingYear;

    /**
     * 开票月份: 取 invoicingTime 的 month
     */
    private String invoicingMonth;

    /**
     * 发票图片
     */
    private String invoiceImagePath;

    /**
     * 发票状态:
     */
    private String invoiceStatus;

    /**
     * 收款单号:发放主体收款登录选择发票，会将收款单号返填到这里
     */
    private String receiptCode;

    /**
     * 收款到账日期
     */
    private LocalDate receiptTime;

    /**
     * 发票添加时间
     * @see settle_invoice_matter_invoice_detail.create_time
     */
    private LocalDateTime invoiceCreateTime;
}
