package com.rocogz.syy.settlement.entity.electronicaccount;

import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 电子账户余额预警用户设置
 * </p>
 *
 * @author ranxiangfu
 * @since 2021-10-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SettleElectronicAccountWarningUser extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 电子账户编号
     */
    private String acctCode;

    /**
     * 用户名
     */
    private String username;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;


}
