package com.rocogz.syy.settlement.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 额度冻结、解冻
 * @author djt
 * @date 2021/5/24
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class AccountFreezeDTO {

    /**
     * 清单编号
     */
    private String applyDetailCode;

    /**
     * 冻结、解冻金额
     */
    private BigDecimal amount;

    /**
     * 操作数量   ，  因为有时会不拆单，不拆单数量会大于1
     */
    private Integer freezeNum;

    /**
     * 每条清单对应的扣款账户编号
     */
    private String acctNo;

    public AccountFreezeDTO(String applyDetailCode, BigDecimal amount, Integer freezeNum) {
        this.applyDetailCode = applyDetailCode;
        this.amount = amount;
        this.freezeNum = freezeNum;
    }
}
