package com.rocogz.syy.settlement.dto;

import com.rocogz.syy.settlement.constant.SettlementConstant;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author djt
 * @date 2021/5/27
 */
@Data
public class PersonAccountAmountResp {

    /**
     * 个人账户编号
     */
    private String acctNo;

    /**
     * 总额度
     */
    private BigDecimal totalAmount;

    /**
     * 可用额度或未划拨额度
     */
    private BigDecimal balanceAmount;

    /**
     * 已用金额或已划拨额度
     */
    private BigDecimal usedAmount;

    /**
     * 已冻结额度
     */
    private BigDecimal freezeAmount;

    /**
     * 已发放金额
     */
    private BigDecimal issuedAmount;

    /**
     * 已领取金额
     */
    private BigDecimal receivedAmount;

    /**
     * 已退款金额
     */
    private BigDecimal refundAmount;

    /**
     * 额度扣减模式（个人账户才有）
     * @see SettlementConstant.DictDeductPattern
     */
    private String deductionPatten;

    /**
     * 用户名
     */
    private String personCode;

    /**
     * 关联团队账户编号
     */
    private String refTeamAccount;

    /**
     * 关联发放主体账户编号
     */
    private String refIssuingBodyAccount;

    /**
     * 关联团队账户可用余额
     */
    private BigDecimal refTeamAccountBalance;

    /**
     * 关联发放主体账户可用余额
     */
    private BigDecimal refIssuingBodyAccountBalance;






}
