package com.rocogz.syy.settlement.dto.electronic.account;

import com.rocogz.syy.settlement.constant.SettlementConstant;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021/4/15 11:05</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class OperateElectronicAcct {
    /**
     * 业务号(保证唯一).
     */
    @NotEmpty
    private String bizCode;

    /**
     * 代理商编号/合作客户编号.
     */
    @NotEmpty
    private String linkCode;

    /**
     * 扣减金额.
     */
    @NotNull
    @Min(0)
    private BigDecimal amount;

    /**
     * 额度账户对应的额度（小程序做额度申请的时候才需要传入此字段）.
     */
    private BigDecimal settleAccountQuota;

    /**
     * 操作类型.
     * @see SettlementConstant.ElectronicAccountOperateType
     */
    private String operateType;

    /**
     * 操作人名称.
     */
    private String operateUserName;

    /**
     * 备注
     * 20232028增加
     */
    private String remark;
}
