package com.rocogz.syy.settlement.entity.electronicaccount;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 电子账户其他信息表
 * </p>
 *
 * @author yifenrui
 * @since 2021-04-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("settle_electronic_account_summary_info")
public class SettleElectronicAccountSummaryInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 电子账户编码
     */
    private String acctCode;

    /**
     * 电子账户类型对应的编码
     */
    private String linkCode;

    /**
     * 虚拟额度-手工增加总额度
     */
    private BigDecimal virtualQuotaRechargeTotal;

    /**
     * 虚拟额度-手工增加总次数
     */
    private Integer virtualQuotaRechargeCount;

    /**
     * 虚拟额度-手工减少总额度
     */
    private BigDecimal virtualQuotaDeductionTotal;

    /**
     * 虚拟额度-手工减少总次数
     */
    private Integer virtualQuotaDeductionCount;

    /**
     * 备付金-充值总额
     */
    private BigDecimal reservePaymentRechargeTotal;

    /**
     * 备付金-充值总次数
     */
    private Integer reservePaymentRechargeCount;

    /**
     * 备付金-借款授信-充值总额
     */
    private BigDecimal reservePaymentRechargeDebtTotal;

    /**
     * 备付金-借款授信-充值总次数
     */
    private Integer reservePaymentRechargeDebtCount;

    /**
     * 备付金-借款授信充值-未还款总额
     */
    private BigDecimal reservePaymentRechargeDebtNotRepaidTotal;

    /**
     * 备付金-借款授信充值-未还款笔数
     */
    private Integer reservePaymentRechargeDebtNotRepaidCount;

    /**
     * 备付金-借款授信充值-已还款总额
     */
    private BigDecimal reservePaymentRechargeDebtRepaidTotal;

    /**
     * 备付金-借款授信充值-已还款笔数
     */
    private Integer reservePaymentRechargeDebtRepaidCount;

    /**
     * 备付金-收款充值-充值总额
     */
    private BigDecimal reservePaymentRechargeCashTotal;

    /**
     * 备付金-收款充值-充值总次数
     */
    private Integer reservePaymentRechargeCashCount;

    /**
     * 订单总数
     */
    private Integer orderCount;

    /**
     * 退款订单数
     */
    private Integer orderRefundCount;

    /**
     * 已发放额度
     */
    private BigDecimal totalGrantQuota;

    /**
     * 已领取额度
     */
    private BigDecimal totalReceivedQuota;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


}
