package com.rocogz.syy.settlement.entity.issuingbody.collection;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 发放主体收款的操作日志
 * </p>
 *
 * @author huhailong
 * @since 2023-04-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SettleIssuingBodyCollectionRecordOperateLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 收款单号
     */
    private String collectionRecordCode;

    /**
     * 操作类型
     */
    private String opType;

    /**
     * 操作内容
     */
    private String opContent;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人 存储的是中文名称
     */
    private String createUser;

}
