package com.rocogz.syy.settlement.enums.invoicematter;

/**
 * @Description: 服务商开票事项状态枚举类
 * @date：2021/9/8
 * @author：huangdeyi
 */
public enum AgentInvoiceMatterStatusEnum {

    /**
     * 草稿
     */
    DRAFT("DRAFT"),

    /**
     * 开票中
     */
    INVOICEING("INVOICEING"),

    /**
     * 已开票
     */
    INVOICED("INVOICED"),

    /**
     * 已部分到账
     */
    PART_RECEIPTED("PART_RECEIPTED"),

    /**
     * 已全部到账
     */
    RECEIPTED("RECEIPTED"),

    /**
     * 已取消
     */
    CANCELED("CANCELED");


    private String status;

    AgentInvoiceMatterStatusEnum(String status) {
        this.status = status;
    }

    public String getStatus() {
        return status;
    }
}
