package com.rocogz.syy.settlement.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.settlement.constant.SettlementConstant;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 【搜索 个人账户列表】结果dto 管理-主体账号专用
 * @author zhangmin
 * @date 2020/6/15
 */
@Setter
@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class AdminSearchPersonalAccountResultDto {

    /**
     * 账户编号
     */
    private String acctNo;

    /**
     * 账户类型
     * @see SettlementConstant.DictAccountType
     */
    private String acctType;

    /**
     * 账户状态
     * @see SettlementConstant.DictSwitchStatus
     */
    private String status;

    //在admin端构建
    private String statusLabel;

    /**
     * 总额度
     */
    private BigDecimal totalAmount;

    /**
     * 可用余额
     */
    private BigDecimal balanceAmount;

    /**
     * 已用金额
     */
    private BigDecimal usedAmount;

    /**
     * 已发放金额
     */
    private BigDecimal issuedAmount;

    /**
     * 已领取金额
     */
    private BigDecimal receivedAmount;

    /**
     * 冻结额度
     */
    private BigDecimal freezeAmount;

    /**
     * 冻结数量
     */
    private Integer freezeCount;


    /**
     * 已退款金额
     */
    private BigDecimal refundAmount;

    /**
     * 已退款笔数
     */
    private Integer refundCount;

    /**
     *  已发放数量
     */
    private Integer issuedCount;

    /**
     *  已领取数量
     */
    private Integer receivedCount;

    /**
     * 用户名 个人账户才有
     */
    private String personCode;

    /**
     * 名字 个人账户才有
     */
    private String personName;

    /**
     * 个人手机号 个人账户才有
     */
    private String personMobile;

    /**
     * 个人账户额度扣减模式
     * @see SettlementConstant.DictDeductPattern
     */
    private String deductionPatten;

     //在admin端构建
    private String deductionPattenLabel;

    /**
     * 所属团队名,如果个人账户加入了团队才有
     * 在admin端构建
     */
    private String teamName;

    /**
     * 所属团队编号,如果个人账户加入了团队才有
     */
    private String teamCode;

    /**
     * 账户创建时间
     */
    private LocalDateTime createTime;

    /**
     * 上级团队账户编号(加入团队个人账户有)
     */
    private String superiorTeamAcctCode;

    /**
     * 上级发放主体账户编号(个人账户、团队账户有)
     */
    private String superiorIssuingBodyAcctCode;

    /**
     * 费用类型
     */
    private String feeType;

}
