package com.rocogz.syy.settlement.dto;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Lists;
import com.rocogz.syy.settlement.constant.SettlementConstant;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDate;
import java.util.List;

/**
 * 【搜索个人账户额度划拨记录】dto  4.9.4【我的账户】详情-主体账号专用
 * @author zhangmin
 * @date 2021/4/8
 */
@Setter @Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class AdminSearchPersonalAdjustRecordDto extends AdminSearchPersonalBaseDto {

    //个人名字【导出Excel时使用】
    private String personName;

    //发放主体登录账号 的 个人账号
    private String personalAcctNo;

    //划拨团队账户编号
    private String teamAcctNo;

    /**
     * 划拨日期-开始日期
     */
    private String startDate;

    /**
     * 划拨日期-结束日期
     */
    private String endDate;

    /**
     * 额度来源账户类型:  发放主体账户\团队账户
     */
    private String fromAcctNoType;

    /**
     * 调整类型
     * @see SettlementConstant.AccountAdjustType
     */
    private String allocateType;

    /**
     * 费用类型
     */
    private String feeType;


    //获取调整的业务类型
    @JsonIgnore
    private List<String> getAllocateTypeList() {
        if(StringUtils.isEmpty(allocateType)) {

            List<String> allocateTypeList = Lists.newArrayList();

            allocateTypeList.add(SettlementConstant.AccountAdjustType.ALLOCATE_IN);

            allocateTypeList.add(SettlementConstant.AccountAdjustType.ALLOCATE_BACK_OUT);

            allocateTypeList.add(SettlementConstant.AccountAdjustType.AUTO_ALLOCATE_IN);

            allocateTypeList.add(SettlementConstant.AccountAdjustType.AUTO_ALLOCATE_BACK_OUT);

            return allocateTypeList;
        }


        return Lists.newArrayList(allocateType);
    }

}
